/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.impl.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;

public class BinaryExchangeImpl
extends BinaryExchangeType
implements BinaryExchange {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public BinaryExchangeImpl(String encodingType, String valueType, byte[] rawText) {
        this.setEncodingType(encodingType);
        this.setValueType(valueType);
        this.setRawValue(rawText);
    }

    public BinaryExchangeImpl(BinaryExchangeType bcType) throws RuntimeException {
        this.setEncodingType(bcType.getEncodingType());
        this.setValueType(bcType.getValueType());
        this.setValue(bcType.getValue());
    }

    @Override
    public byte[] getRawValue() {
        try {
            return Base64.decode((String)this.getTextValue());
        }
        catch (Base64DecodingException de) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0020_ERROR_DECODING(this.getTextValue()), de);
            throw new RuntimeException(LogStringsMessages.WST_0020_ERROR_DECODING(this.getTextValue()), de);
        }
    }

    @Override
    public String getTextValue() {
        return super.getValue();
    }

    @Override
    public void setTextValue(@NotNull String encodedText) {
        super.setValue(encodedText);
    }

    @Override
    public final void setRawValue(@NotNull byte[] rawText) {
        super.setValue(Base64.encode((byte[])rawText));
    }
}

