/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.logging.LogStringsMessages;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigestCertSelector
implements CertSelector {
    private final byte[] keyId;
    private final String algorithm;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public DigestCertSelector(byte[] keyIdValue, String algo) {
        this.keyId = keyIdValue;
        this.algorithm = algo;
    }

    @Override
    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
            byte[] thumbPrintIdentifier = null;
            try {
                thumbPrintIdentifier = MessageDigest.getInstance(this.algorithm).digest(cert.getEncoded());
            }
            catch (NoSuchAlgorithmException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0708_NO_DIGEST_ALGORITHM(), ex);
                throw new RuntimeException("Digest algorithm SHA-1 not found");
            }
            catch (CertificateEncodingException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0709_ERROR_GETTING_RAW_CONTENT(), ex);
                throw new RuntimeException("Error while getting certificate's raw content");
            }
            if (Arrays.equals(thumbPrintIdentifier, this.keyId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        return new DigestCertSelector(this.keyId, this.algorithm);
    }
}

