/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class KeyIdentifierCertSelector
implements CertSelector {
    private final byte[] keyId;

    public KeyIdentifierCertSelector(byte[] keyIdValue) {
        this.keyId = keyIdValue;
    }

    @Override
    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
            byte[] keyIdtoMatch = null;
            try {
                keyIdtoMatch = X509SubjectKeyIdentifier.getSubjectKeyIdentifier((X509Certificate)cert);
            }
            catch (XWSSecurityException xWSSecurityException) {
                // empty catch block
            }
            if (Arrays.equals(keyIdtoMatch, this.keyId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        return new KeyIdentifierCertSelector(this.keyId);
    }
}

