/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.ToolVersion;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

abstract class WsTask2
extends MatchingTask {
    private Path modulepath = null;
    private Path upgrademodulepath = null;
    private String addmodules = null;
    private String limitmodules = null;
    private String addreads = null;
    private String addexports = null;
    private String patchmodule = null;
    private String addopens = null;
    private final CommandlineJava cmd = new CommandlineJava();
    private File destDir = null;
    private boolean extension;
    private boolean keep = false;
    private boolean fork = false;
    private File sourcedestdir;
    private String encoding;
    private boolean verbose = false;
    private boolean debug = false;
    private final Commandline javacCmdLine = new Commandline();
    private boolean xendorsed = false;
    private boolean xnocompile = false;
    private boolean failonerror = true;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    WsTask2() {
    }

    public void setModulepath(Path mp) {
        this.modulepath = mp;
    }

    public Path getModulepath() {
        return this.modulepath;
    }

    public void setUpgrademodulepath(Path ump) {
        this.upgrademodulepath = ump;
    }

    public Path getUpgrademodulepath() {
        return this.upgrademodulepath;
    }

    public void setAddmodules(String ams) {
        this.addmodules = ams;
    }

    public String getAddmodules() {
        return this.addmodules;
    }

    public void setLimitmodules(String lms) {
        this.limitmodules = lms;
    }

    public String getLimitmodules() {
        return this.limitmodules;
    }

    public void setAddreads(String ars) {
        this.addreads = ars;
    }

    public String getAddreads() {
        return this.addreads;
    }

    public void setAddexports(String aes) {
        this.addexports = aes;
    }

    public String getAddexports() {
        return this.addexports;
    }

    public void setPatchmodule(String pms) {
        this.patchmodule = pms;
    }

    public String getPatchmodule() {
        return this.patchmodule;
    }

    public void setAddopens(String aos) {
        this.addopens = aos;
    }

    public String getAddopens() {
        return this.addopens;
    }

    CommandlineJava getCommandline() {
        return this.cmd;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public File getSourcedestdir() {
        return this.sourcedestdir;
    }

    public void setSourcedestdir(File sourceBase) {
        this.keep = true;
        this.sourcedestdir = sourceBase;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Commandline.Argument createJavacarg() {
        return this.javacCmdLine.createArgument();
    }

    public Commandline getJavacargs() {
        return this.javacCmdLine;
    }

    public void setXendorsed(boolean xendorsed) {
        this.xendorsed = xendorsed;
    }

    public boolean isXendorsed() {
        return this.xendorsed;
    }

    public boolean isXnocompile() {
        return this.xnocompile;
    }

    public void setXnocompile(boolean xnocompile) {
        this.xnocompile = xnocompile;
    }

    public void setFailonerror(boolean value) {
        this.failonerror = value;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute(String tool, String toolClass) throws BuildException {
        this.setupCommand();
        LogOutputStream logstr = null;
        boolean ok = false;
        try {
            if (this.getVerbose()) {
                this.log(ToolVersion.VERSION.BUILD_VERSION);
                this.log("command line: " + tool + (this.getFork() ? this.getCommandline().getJavaCommand() : this.getCommandline()).toString());
            }
            if (this.getFork()) {
                this.setupForkCommand(toolClass);
                int status = this.run(this.getCommandline().getCommandline());
                ok = status == 0;
            } else {
                if (this.getCommandline().getVmCommand().size() > 1) {
                    this.log("JVM args ignored when same JVM is used.", 1);
                }
                logstr = new LogOutputStream((Task)this, 1);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    ok = this.runInVm(this.getCommandline().getJavaCommand().getArguments(), (OutputStream)logstr);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (!ok) {
                if (!this.getVerbose()) {
                    this.log("Command invoked: " + tool + this.getCommandline().toString());
                }
                throw new BuildException(tool + " failed", this.getLocation());
            }
        }
        catch (Exception ex) {
            if (this.isFailonerror()) {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error starting " + tool + ": " + ex.getMessage(), (Throwable)ex, this.getLocation());
            }
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.getProject().log(sw.toString(), 1);
        }
        finally {
            try {
                if (logstr != null) {
                    logstr.close();
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected CommandlineJava setupCommand() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.getCommandline().createArgument().setValue("-d");
            this.getCommandline().createArgument().setFile(this.getDestdir());
        }
        if (this.getExtension()) {
            this.getCommandline().createArgument().setValue("-extension");
        }
        if (this.isXendorsed()) {
            this.getCommandline().createArgument().setValue("-Xendorsed");
        }
        if (this.getKeep()) {
            this.getCommandline().createArgument().setValue("-keep");
        }
        if (null != this.getSourcedestdir() && !this.getSourcedestdir().getName().equals("")) {
            this.getCommandline().createArgument().setValue("-s");
            this.getCommandline().createArgument().setFile(this.getSourcedestdir());
        }
        if (this.getEncoding() != null) {
            this.getCommandline().createArgument().setValue("-encoding");
            this.getCommandline().createArgument().setValue(this.getEncoding());
        }
        if (this.getDebug()) {
            this.getCommandline().createArgument().setValue("-g");
        }
        if (this.getVerbose()) {
            this.getCommandline().createArgument().setValue("-verbose");
        }
        return this.getCommandline();
    }

    protected abstract boolean runInVm(String[] var1, OutputStream var2);

    public void setupForkCommand(String className) {
        ClassLoader loader;
        for (loader = ((Object)((Object)this)).getClass().getClassLoader(); loader != null && !(loader instanceof AntClassLoader); loader = loader.getParent()) {
        }
        Object antcp = loader != null ? ((AntClassLoader)loader).getClasspath() : System.getProperty("java.class.path");
        File jreHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
        if (toolsJar.exists()) {
            antcp = (String)antcp + File.pathSeparatorChar + toolsJar.getAbsolutePath();
        }
        Path cp = this.getCommandline().createClasspath(this.getProject());
        if (System.getProperty("jdk.module.path") != null) {
            this.log("Changing original module path to classpath.", 1);
            antcp = (String)antcp + File.pathSeparatorChar + System.getProperty("jdk.module.path");
        }
        cp.append(new Path(this.getProject(), (String)antcp));
        Path mvn = (Path)this.getProject().getReference("maven.plugin.classpath");
        if (mvn != null) {
            cp.append(mvn);
        }
        if (this.getModulepath() != null && this.getModulepath().size() > 0) {
            this.getCommandline().createModulepath(this.getProject()).add(this.getModulepath());
        }
        if (this.getUpgrademodulepath() != null && this.getUpgrademodulepath().size() > 0) {
            this.getCommandline().createUpgrademodulepath(this.getProject()).add(this.getUpgrademodulepath());
        }
        if (this.getAddmodules() != null && this.getAddmodules().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--add-modules " + this.getAddmodules());
        }
        if (this.getAddreads() != null && this.getAddreads().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--add-reads " + this.getAddreads());
        }
        if (this.getAddexports() != null && this.getAddexports().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--add-exports " + this.getAddexports());
        }
        if (this.getAddopens() != null && this.getAddopens().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--add-opens " + this.getAddopens());
        }
        if (this.getPatchmodule() != null && this.getPatchmodule().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--patch-module " + this.getPatchmodule());
        }
        if (this.getLimitmodules() != null && this.getLimitmodules().length() > 0) {
            this.getCommandline().createVmArgument().setLine("--limit-modules " + this.getLimitmodules());
        }
        this.getCommandline().setClassname(className);
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.getProject());
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }
}

