/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.wss.provider.wsit.AuthParam;
import jakarta.xml.soap.SOAPMessage;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class SOAPAuthParam
implements AuthParam {
    private HashMap<Object, Object> infoMap;
    private boolean requestInPacket;
    private boolean responseInPacket;
    private SOAPMessage request;
    private SOAPMessage response;
    private static Exception classLoadingException = SOAPAuthParam.checkForPacket();
    private static final String REQ_PACKET = "REQ_PACKET";
    private static final String RES_PACKET = "RES_PACKET";
    private static boolean REQUEST_PACKET = true;
    private static boolean RESPONSE_PACKET = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Exception checkForPacket() {
        Exception rvalue = null;
        try {
            if (Class.forName("com.sun.xml.ws.api.message.Packet") == null) return rvalue;
            if (Class.forName("com.sun.xml.ws.api.message.Messages") == null) return rvalue;
        }
        catch (Exception e) {
            return e;
        }
        return rvalue;
    }

    public SOAPAuthParam(SOAPMessage request, SOAPMessage response) {
        this.infoMap = null;
        this.request = request;
        this.response = response;
    }

    public SOAPAuthParam(Object request, Object response, int dummy2) {
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        if (request != null && !(request instanceof Packet) || response != null && !(response instanceof Packet)) {
            throw new RuntimeException("argument is not packet");
        }
        this.infoMap = new HashMap();
        this.infoMap.put(REQ_PACKET, request);
        this.infoMap.put(RES_PACKET, response);
        this.requestInPacket = request != null;
        this.responseInPacket = response != null;
    }

    public Map<Object, Object> getMap() {
        if (this.infoMap == null) {
            this.infoMap = new HashMap();
        }
        return this.infoMap;
    }

    public SOAPMessage getRequest() {
        Object p;
        if (this.request == null && (p = this.getPacket(REQUEST_PACKET, true)) != null && this.requestInPacket) {
            this.request = this.getSOAPFromPacket(REQUEST_PACKET, p);
        }
        return this.request;
    }

    public SOAPMessage getResponse() {
        Object p;
        if (this.response == null && (p = this.getPacket(RESPONSE_PACKET, false)) != null && this.responseInPacket) {
            this.response = this.getSOAPFromPacket(RESPONSE_PACKET, p);
        }
        return this.response;
    }

    public void setRequest(SOAPMessage request) {
        Object p = this.getPacket(REQUEST_PACKET, false);
        if (p != null) {
            this.requestInPacket = this.putSOAPInPacket(request, p);
        }
        this.request = request;
    }

    public void setResponse(SOAPMessage response) {
        Object p = this.getPacket(RESPONSE_PACKET, false);
        if (p != null) {
            this.responseInPacket = this.putSOAPInPacket(response, p);
        }
        this.response = response;
    }

    public Object getRequestPacket() {
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        return this.getPacket(REQUEST_PACKET, true);
    }

    public Object getResponsePacket() {
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        return this.getPacket(RESPONSE_PACKET, true);
    }

    public void setRequestPacket(Object p) {
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        if (p != null && !(p instanceof Packet)) {
            throw new RuntimeException("argument is not packet");
        }
        this.getMap().put(REQ_PACKET, p);
        this.requestInPacket = p != null;
        this.request = null;
    }

    public void setResponsePacket(Object p) {
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        if (p != null && !(p instanceof Packet)) {
            throw new RuntimeException("argument is not packet");
        }
        this.getMap().put(RES_PACKET, p);
        this.responseInPacket = p != null;
        this.response = null;
    }

    private Object getPacket(boolean isRequestPacket, boolean putDesired) {
        Object p;
        Object object = this.infoMap == null ? null : (p = this.infoMap.get(isRequestPacket ? REQ_PACKET : RES_PACKET));
        if (putDesired) {
            SOAPMessage m;
            SOAPMessage sOAPMessage = m = isRequestPacket ? this.request : this.response;
            if (p != null && m != null) {
                if (isRequestPacket) {
                    if (!this.requestInPacket) {
                        this.requestInPacket = this.putSOAPInPacket(m, p);
                    }
                } else if (!this.responseInPacket) {
                    this.responseInPacket = this.putSOAPInPacket(m, p);
                }
            }
        }
        return p;
    }

    private SOAPMessage getSOAPFromPacket(boolean isRequestPacket, Object p) {
        Message m;
        if (classLoadingException != null) {
            throw new RuntimeException(classLoadingException);
        }
        SOAPMessage s = null;
        if (p instanceof Packet && (m = ((Packet)p).getMessage()) != null) {
            try {
                s = m.readAsSOAPMessage();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (s != null) {
            if (isRequestPacket) {
                this.requestInPacket = false;
            } else {
                this.responseInPacket = false;
            }
        }
        return s;
    }

    private boolean putSOAPInPacket(SOAPMessage m, Object p) {
        if (m == null) {
            ((Packet)p).setMessage(null);
        } else {
            Message msg = Messages.create(m);
            ((Packet)p).setMessage(msg);
        }
        return true;
    }

    public static void printSOAP(SOAPMessage s) {
        try {
            if (s != null) {
                s.writeTo((OutputStream)System.out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

