/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.util;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.logging.saml.LogStringsMessages;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import com.sun.xml.wss.saml.util.WSSNamespacePrefixMapper;
import com.sun.xml.wss.util.DateUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLUtil {
    private static Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security.saml", "com.sun.xml.wss.logging.saml.LogStrings");

    public static Element locateSamlAssertion(String assertionId, Document soapDocument) {
        int nodeListLength;
        NodeList nodeList = null;
        nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        if (nodeList.item(0) == null) {
            nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        }
        if ((nodeListLength = nodeList.getLength()) == 0) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_001_SAML_ASSERTION_NOT_FOUND(assertionId));
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
        }
        for (int i = 0; i < nodeListLength; ++i) {
            Element assertion = (Element)nodeList.item(i);
            String aId = assertion.getAttribute("AssertionID");
            String id = assertion.getAttribute("ID");
            if (!aId.equals(assertionId) && !id.equals(assertionId)) continue;
            return assertion;
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_001_SAML_ASSERTION_NOT_FOUND(assertionId));
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
    }

    public static Element toElement(Node doc, Object element) throws XWSSecurityException {
        return SAMLUtil.toElement(doc, element, null);
    }

    public static Element toElement(Node doc, Object element, JAXBContext jcc) throws XWSSecurityException {
        Element el;
        DOMResult result = null;
        Document document = null;
        if (doc != null) {
            result = new DOMResult(doc);
        } else {
            try {
                DocumentBuilderFactory factory = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_002_FAILED_CREATE_DOCUMENT(), ex);
                throw new XWSSecurityException("Unable to create Document : " + ex.getMessage());
            }
            result = new DOMResult(document);
        }
        try {
            JAXBContext jc = jcc;
            if (jc == null) {
                jc = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? (element instanceof Assertion ? SAML20JAXBUtil.getJAXBContext() : SAMLJAXBUtil.getJAXBContext()) : SAMLJAXBUtil.getJAXBContext();
            }
            Marshaller m = jc.createMarshaller();
            if (element == null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Element is Null in SAMLUtil.toElement()");
            }
            m.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new WSSNamespacePrefixMapper());
            m.marshal(element, (Result)result);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_003_FAILEDTO_MARSHAL(), ex);
            throw new XWSSecurityException("Not able to Marshal " + element.getClass().getName() + ", got exception: " + ex.getMessage());
        }
        if (doc != null) {
            if (doc.getNodeType() == 1) {
                if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                    el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                    return el;
                }
                el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
                return el;
            }
            if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                return el;
            }
            el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
            return el;
        }
        if (document.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
            return el;
        }
        el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
        return el;
    }

    public static Element createSAMLAssertion(XMLStreamReader reader) throws XWSSecurityException, XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        StreamWriterBufferCreator bCreator = new StreamWriterBufferCreator(buffer);
        Document doc = null;
        try {
            XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
            StreamWriterBufferCreator writer_tmp = bCreator;
            while (8 != reader.getEventType()) {
                StreamUtil.writeCurrentEvent(reader, (XMLStreamWriter)((Object)writer_tmp));
                reader.next();
            }
            buffer.writeToXMLStreamWriter(writer);
            writer.close();
            try {
                baos.close();
            }
            catch (IOException ex) {
                throw new XWSSecurityException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", ex);
            }
            DocumentBuilderFactory dbf = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new ByteArrayInputStream(baos.toByteArray()));
            return doc.getDocumentElement();
        }
        catch (XMLStreamException xe) {
            throw new XMLStreamException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", xe);
        }
        catch (Exception xe) {
            throw new XWSSecurityException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", xe);
        }
    }

    public static boolean validateTimeInConditionsStatement(Element samlAssertion) throws XWSSecurityException {
        Date _notBefore = null;
        Date _notOnOrAfter = null;
        NodeList nl = samlAssertion.getElementsByTagNameNS(samlAssertion.getNamespaceURI(), "Conditions");
        Node conditionsElement = null;
        if (nl == null || nl.getLength() <= 0) {
            logger.log(Level.INFO, "No Conditions Element found in SAML Assertion");
            return true;
        }
        conditionsElement = nl.item(0);
        Element elt = (Element)conditionsElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            throw new XWSSecurityException("Internal Error: LocalName of Conditions Element found Null");
        }
        if (!eltName.equals("Conditions")) {
            throw new XWSSecurityException("Internal Error: LocalName of Conditions Element found to be :" + eltName);
        }
        String dt = elt.getAttribute("NotBefore");
        if (dt != null && !dt.equals("")) {
            try {
                _notBefore = DateUtils.stringToDate(dt);
            }
            catch (ParseException pe) {
                throw new XWSSecurityException(pe);
            }
        }
        if ((dt = elt.getAttribute("NotOnOrAfter")) != null && !dt.equals("")) {
            try {
                _notOnOrAfter = DateUtils.stringToDate(elt.getAttribute("NotOnOrAfter"));
            }
            catch (ParseException pe) {
                throw new XWSSecurityException(pe);
            }
        }
        long someTime = System.currentTimeMillis();
        if (_notBefore == null) {
            if (_notOnOrAfter == null) {
                return true;
            }
            if (someTime < _notOnOrAfter.getTime()) {
                return true;
            }
        } else if (_notOnOrAfter == null ? someTime >= _notBefore.getTime() : someTime >= _notBefore.getTime() && someTime < _notOnOrAfter.getTime()) {
            return true;
        }
        return false;
    }

    public static boolean verifySignature(Element samlAssertion, PublicKey pubKey) throws XWSSecurityException {
        try {
            HashMap<String, Element> map = new HashMap<String, Element>();
            String id = samlAssertion.getAttribute("ID");
            if (id == null || id.length() < 1) {
                id = samlAssertion.getAttribute("AssertionID");
            }
            map.put(id, samlAssertion);
            NodeList nl = samlAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new XWSSecurityException("Unsigned SAML Assertion encountered while verifying the SAML signature");
            }
            Element signElement = (Element)nl.item(0);
            DOMValidateContext validationContext = new DOMValidateContext(pubKey, (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature xmlSignature = signatureFactory.unmarshalXMLSignature(validationContext);
            validationContext.setURIDereferencer(new DSigResolver(map, samlAssertion));
            boolean coreValidity = xmlSignature.validate(validationContext);
            return coreValidity;
        }
        catch (Exception ex) {
            throw new XWSSecurityException(ex);
        }
    }

    private static class DSigResolver
    implements URIDereferencer {
        Element elem = null;
        Map map = null;
        Class<?> _nodeSetClass = null;
        String optNSClassName = "org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData";
        Constructor _constructor = null;
        Boolean _false = false;

        DSigResolver(Map map, Element elem) {
            this.elem = elem;
            this.map = map;
            this.init();
        }

        void init() {
            try {
                this._nodeSetClass = Class.forName(this.optNSClassName);
                this._constructor = this._nodeSetClass.getConstructor(Node.class, Boolean.TYPE);
            }
            catch (LinkageError linkageError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        @Override
        public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
            try {
                String uri = null;
                uri = uriRef.getURI();
                return this.dereferenceURI(uri, context);
            }
            catch (Exception ex) {
                throw new URIReferenceException(ex);
            }
        }

        Data dereferenceURI(String uri, XMLCryptoContext context) throws URIReferenceException {
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1, uri.length());
                Element el = this.elem.getOwnerDocument().getElementById(uri);
                if (el == null) {
                    el = (Element)this.map.get(uri);
                }
                if (this._constructor != null) {
                    try {
                        return (Data)this._constructor.newInstance(el, this._false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    final HashSet<Object> nodeSet = new HashSet<Object>();
                    this.toNodeSet(el, nodeSet);
                    return new NodeSetData(){

                        @Override
                        public Iterator iterator() {
                            return nodeSet.iterator();
                        }
                    };
                }
            }
            return null;
        }

        void toNodeSet(Node rootNode, Set<Object> result) {
            switch (rootNode.getNodeType()) {
                case 1: {
                    result.add(rootNode);
                    Element el = (Element)rootNode;
                    if (el.hasAttributes()) {
                        NamedNodeMap nl = rootNode.getAttributes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            result.add(nl.item(i));
                        }
                    }
                }
                case 9: {
                    for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                        if (r.getNodeType() == 3) {
                            result.add(r);
                            while (r != null && r.getNodeType() == 3) {
                                r = r.getNextSibling();
                            }
                            if (r == null) {
                                return;
                            }
                        }
                        this.toNodeSet(r, result);
                    }
                    return;
                }
                case 8: {
                    return;
                }
                case 10: {
                    return;
                }
            }
            result.add(rootNode);
        }
    }
}

