/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.tools.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class JavacompilerMessages {

    private final static String BUNDLE_NAME = "com.sun.tools.ws.resources.javacompiler";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new JavacompilerMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private JavacompilerMessages() {
    }

    public static Localizable localizableNO_JAVACOMPILER_ERROR() {
        return MESSAGE_FACTORY.getMessage("no.javacompiler.error");
    }

    /**
     * No system compiler found, check your jdk.
     * 
     */
    public static String NO_JAVACOMPILER_ERROR() {
        return LOCALIZER.localize(localizableNO_JAVACOMPILER_ERROR());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
