/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.WsimportListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;

public class Options {
    private static final String JAVAX_XML_WS = "javax.xml.ws";
    private static final String JAKARTA_XML_WS = "jakarta.xml.ws";
    private static final String JAVAX_JWS = "javax.jws";
    private static final String JAKARTA_JWS = "jakarta.jws";
    private static final String JAVAX_XML_BIND = "javax.xml.bind";
    private static final String JAKARTA_XML_BIND = "jakarta.xml.bind";
    private static final String JAXB_CORE = "org.glassfish.jaxb.core";
    private static final String JAXB_BIND = "com.sun.xml.bind";
    protected final Map<String, String> classNameReplacer = new HashMap<String, String>();
    public boolean verbose;
    public boolean quiet;
    public boolean keep;
    public File destDir = new File(".");
    public File sourceDir;
    public Filer filer;
    public String encoding;
    public String classpath = System.getProperty("java.class.path");
    public List<String> javacOptions;
    public boolean nocompile;
    public boolean disableXmlSecurity;
    public Target target = Target.V3_0;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    public boolean debug = false;
    public boolean debugMode = false;
    private final List<File> generatedFiles = new ArrayList<File>();
    private ClassLoader classLoader;

    public boolean isExtensionMode() {
        return this.compatibilityMode == 2;
    }

    @Deprecated
    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public void addGeneratedFile(FileObject fo) {
        this.generatedFiles.add(new File(fo.toUri()));
    }

    public void removeGeneratedFiles() {
        for (File file : this.generatedFiles) {
            if (!file.getName().endsWith(".java")) continue;
            boolean deleted = file.delete();
            if (!this.verbose || deleted) continue;
            System.out.println(MessageFormat.format("{0} could not be deleted.", file));
        }
        this.generatedFiles.clear();
    }

    public Iterable<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        List<File> list = this.generatedFiles;
        synchronized (list) {
            for (File file : this.generatedFiles) {
                if (!file.getName().endsWith(".java")) continue;
                boolean deleted = file.delete();
                if (!this.verbose || deleted) continue;
                System.out.println(MessageFormat.format("{0} could not be deleted.", file));
            }
            this.generatedFiles.clear();
        }
    }

    public void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArguments(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(args[i]));
                }
                i += j - 1;
                continue;
            }
            this.addFile(args[i]);
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
    }

    protected void addFile(String arg) throws BadCommandLineException {
    }

    protected int parseArguments(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-g")) {
            this.debug = true;
            return 1;
        }
        if (args[i].equals("-Xdebug")) {
            this.debugMode = true;
            return 1;
        }
        if (args[i].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (args[i].equals("-keep")) {
            this.keep = true;
            return 1;
        }
        if (args[i].equals("-target")) {
            String token = this.requireArgument("-target", args, ++i);
            this.target = Target.parse(token);
            if (this.target == null) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_ILLEGAL_TARGET_VERSION(token));
            }
            this.addClassNameReplacers(this.target);
            return 2;
        }
        if (args[i].equals("-classpath") || args[i].equals("-cp")) {
            this.classpath = this.requireArgument("-classpath", args, ++i) + File.pathSeparator + System.getProperty("java.class.path");
            return 2;
        }
        if (args[i].equals("-d")) {
            this.destDir = new File(this.requireArgument("-d", args, ++i));
            if (!this.destDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.destDir.getPath()));
            }
            return 2;
        }
        if (args[i].equals("-s")) {
            this.sourceDir = new File(this.requireArgument("-s", args, ++i));
            this.keep = true;
            if (!this.sourceDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.sourceDir.getPath()));
            }
            return 2;
        }
        if (args[i].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (args[i].startsWith("-help")) {
            WeAreDone done = new WeAreDone();
            done.initOptions(this);
            throw done;
        }
        if (args[i].equals("-Xnocompile")) {
            this.nocompile = true;
            this.keep = true;
            return 1;
        }
        if (args[i].equals("-encoding")) {
            this.encoding = this.requireArgument("-encoding", args, ++i);
            try {
                if (!Charset.isSupported(this.encoding)) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_UNSUPPORTED_ENCODING(this.encoding));
                }
            }
            catch (IllegalCharsetNameException icne) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_UNSUPPORTED_ENCODING(this.encoding));
            }
            return 2;
        }
        if (args[i].equals("-disableXmlSecurity")) {
            this.disableXmlSecurity();
            return 1;
        }
        if (args[i].startsWith("-J")) {
            if (this.javacOptions == null) {
                this.javacOptions = new ArrayList<String>();
            }
            this.javacOptions.add(args[i].substring(2));
            return 1;
        }
        return 0;
    }

    private void addClassNameReplacers(Target target) {
        if (target.ordinal() < Target.V3_0.ordinal()) {
            this.classNameReplacer.put(JAKARTA_XML_BIND, JAVAX_XML_BIND);
            this.classNameReplacer.put(JAXB_CORE, JAXB_BIND);
            this.classNameReplacer.put(JAKARTA_XML_WS, JAVAX_XML_WS);
            this.classNameReplacer.put(JAKARTA_JWS, JAVAX_JWS);
        }
    }

    protected void disableXmlSecurity() {
        this.disableXmlSecurity = true;
    }

    public String requireArgument(String optionName, String[] args, int i) throws BadCommandLineException {
        if (args[i].startsWith("-")) {
            throw new BadCommandLineException(WscompileMessages.WSCOMPILE_MISSING_OPTION_ARGUMENT(optionName));
        }
        return args[i];
    }

    public List<String> getJavacOptions(List<String> existingOptions, WsimportListener listener) {
        ArrayList<String> result = new ArrayList<String>();
        for (String o : this.javacOptions) {
            if (o.contains("=") && !o.startsWith("A")) {
                int i = o.indexOf(61);
                String key = o.substring(0, i);
                if (existingOptions.contains(key)) {
                    listener.message(WscompileMessages.WSCOMPILE_EXISTING_OPTION(key));
                    continue;
                }
                result.add(key);
                result.add(o.substring(i + 1));
                continue;
            }
            if (existingOptions.contains(o)) {
                listener.message(WscompileMessages.WSCOMPILE_EXISTING_OPTION(o));
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(Options.pathToURLs(this.classpath), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = Options.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static URL fileToURL(File file) {
        Object name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = ((String)name).replace(File.separatorChar, '/');
        if (!((String)name).startsWith("/")) {
            name = "/" + (String)name;
        }
        if (!file.isFile()) {
            name = (String)name + "/";
        }
        try {
            return new URL("file", "", (String)name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public static enum Target {
        V2_3("2.3"),
        V3_0("3.0");

        private final String version;
        private static final Target LOADED_API_VERSION;

        private Target(String version) {
            this.version = version;
        }

        public boolean isLaterThan(Target t) {
            return this.ordinal() >= t.ordinal();
        }

        public static Target parse(String token) {
            for (Target target : Target.values()) {
                if (!target.getVersion().equals(token)) continue;
                return target;
            }
            return null;
        }

        public String getVersion() {
            return this.version;
        }

        public static Target getDefault() {
            return V3_0;
        }

        public static Target getLoadedAPIVersion() {
            return LOADED_API_VERSION;
        }

        static {
            LOADED_API_VERSION = V3_0;
        }
    }

    public static final class WeAreDone
    extends BadCommandLineException {
        private static final long serialVersionUID = -6884985421553580631L;

        private WeAreDone() {
        }
    }
}

