/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public final class Postman {
    private static final Logger LOGGER = Logger.getLogger(Postman.class);
    private final Executor executor = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };

    Postman() {
    }

    public void deliver(final ApplicationMessage message, final Callback deliveryCallback) {
        final HaContext.State state = HaContext.currentState();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Scheduling delivery execution of a message with number [ %d ] on a sequence [ %s ] using current HA context state [ %s ]", message.getMessageNumber(), message.getSequenceId(), state.toString()));
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("Executing delivery of a message with number [ %d ] on a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
                }
                HaContext.State oldState = HaContext.initFrom(state);
                try {
                    deliveryCallback.deliver(message);
                }
                finally {
                    HaContext.initFrom(oldState);
                }
            }
        });
    }

    public static interface Callback {
        public void deliver(ApplicationMessage var1);

        public RuntimeContext getRuntimeContext();
    }
}

