/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TxLogger {
    private static final String LOGGING_SUBSYSTEM_NAME;
    private final String componentClassName;
    private final Logger logger;

    private TxLogger(String componentName) {
        this.componentClassName = "[" + componentName + "] ";
        this.logger = Logger.getLogger(LOGGING_SUBSYSTEM_NAME);
    }

    private TxLogger(String componentName, String subsystem) {
        this.componentClassName = "[" + componentName + "] ";
        this.logger = Logger.getLogger(LOGGING_SUBSYSTEM_NAME + subsystem);
    }

    public static TxLogger getLogger(Class componentClass) {
        return new TxLogger(componentClass.getName());
    }

    public static TxLogger getATLogger(Class componentClass) {
        return new TxLogger(componentClass.getName(), ".wsat");
    }

    public static TxLogger getCoordLogger(Class componentClass) {
        return new TxLogger(componentClass.getName(), ".wscoord");
    }

    public void log(Level level, String methodName, String message) {
        this.logger.logp(level, this.componentClassName, methodName, message);
    }

    public void log(Level level, String methodName, String message, Throwable thrown) {
        this.logger.logp(level, this.componentClassName, methodName, message, thrown);
    }

    public void finest(String methodName, String message) {
        this.logger.logp(Level.FINEST, this.componentClassName, methodName, message);
    }

    public void finest(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.FINEST, this.componentClassName, methodName, message, thrown);
    }

    public void finer(String methodName, String message) {
        this.logger.logp(Level.FINER, this.componentClassName, methodName, message);
    }

    public void finer(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.FINER, this.componentClassName, methodName, message, thrown);
    }

    public void fine(String methodName, String message) {
        this.logger.logp(Level.FINE, this.componentClassName, methodName, message);
    }

    public void fine(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.FINE, this.componentClassName, methodName, message, thrown);
    }

    public void info(String methodName, String message) {
        this.logger.logp(Level.INFO, this.componentClassName, methodName, message);
    }

    public void info(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.INFO, this.componentClassName, methodName, message, thrown);
    }

    public void config(String methodName, String message) {
        this.logger.logp(Level.CONFIG, this.componentClassName, methodName, message);
    }

    public void config(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.CONFIG, this.componentClassName, methodName, message, thrown);
    }

    public void warning(String methodName, String message) {
        this.logger.logp(Level.WARNING, this.componentClassName, methodName, message);
    }

    public void warning(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.WARNING, this.componentClassName, methodName, message, thrown);
    }

    public void severe(String methodName, String message) {
        this.logger.logp(Level.SEVERE, this.componentClassName, methodName, message);
    }

    public void severe(String methodName, String message, Throwable thrown) {
        this.logger.logp(Level.SEVERE, this.componentClassName, methodName, message, thrown);
    }

    public void entering(String methodName) {
        this.logger.entering(this.componentClassName, methodName);
    }

    public void entering(String methodName, Object parameter) {
        this.logger.entering(this.componentClassName, methodName, parameter);
    }

    public void entering(String methodName, Object[] parameters) {
        this.logger.entering(this.componentClassName, methodName, parameters);
    }

    public void exiting(String methodName) {
        this.logger.exiting(this.componentClassName, methodName);
    }

    public void exiting(String methodName, Object result) {
        this.logger.exiting(this.componentClassName, methodName, result);
    }

    public boolean isLogging(Level level) {
        return this.logger.isLoggable(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String loggingSubsystemName = null;
        try {
            Class<?> jaxwsConstants = Class.forName("com.sun.xml.ws.util.Constants");
            Field loggingDomainField = jaxwsConstants.getField("LoggingDomain");
            Object loggingDomain = loggingDomainField.get(null);
            loggingSubsystemName = loggingDomain.toString().concat(".wstx");
        }
        catch (Exception e) {
            loggingSubsystemName = "wstx";
        }
        finally {
            LOGGING_SUBSYSTEM_NAME = loggingSubsystemName;
        }
    }
}

