/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.commons.AbstractTaskManager;
import com.sun.xml.ws.commons.NamedThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class DelayedTaskManager
extends AbstractTaskManager {
    private static final Logger LOGGER = Logger.getLogger(DelayedTaskManager.class);
    private final Component component;
    private final String threadPoolName;
    private final int coreThreadPoolSize;

    public static DelayedTaskManager createManager(String name, int coreThreadPoolSize, Component component) {
        return new DelayedTaskManager(name, coreThreadPoolSize, component);
    }

    private static final ThreadFactory createThreadFactory(String name) {
        return new NamedThreadFactory(name);
    }

    private DelayedTaskManager(String name, int coreThreadPoolSize, Component component) {
        this.threadPoolName = name;
        this.coreThreadPoolSize = coreThreadPoolSize;
        this.component = component;
    }

    public boolean register(@NotNull DelayedTask task, long delay, TimeUnit timeUnit) {
        if (this.isClosed()) {
            LOGGER.finer(String.format("Attempt to register a new task has failed. This '%s' instance has already been closed", this.getClass().getName()));
            return false;
        }
        assert (task != null);
        this.getExecutorService().schedule(new Worker(task), delay, timeUnit);
        return true;
    }

    @Override
    protected Component getComponent() {
        return this.component;
    }

    @Override
    protected String getThreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    protected ThreadFactory createThreadFactory() {
        return DelayedTaskManager.createThreadFactory(this.threadPoolName);
    }

    @Override
    protected int getThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private class Worker
    implements Runnable {
        public final DelayedTask task;

        public Worker(DelayedTask handler) {
            this.task = handler;
        }

        @Override
        public void run() {
            LOGGER.entering();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Starting delayed execution of [ %s ]", this.task.getName()));
            }
            try {
                this.task.run(DelayedTaskManager.this);
            }
            catch (Exception ex) {
                try {
                    LOGGER.warning(String.format("An exception occured during execution of [ %s ]", this.task.getName()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(String.format("Delayed execution of [ %s ] finished", this.task.getName()));
                    }
                    LOGGER.exiting();
                    throw throwable;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("Delayed execution of [ %s ] finished", this.task.getName()));
                }
                LOGGER.exiting();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Delayed execution of [ %s ] finished", this.task.getName()));
            }
            LOGGER.exiting();
        }
    }

    public static interface DelayedTask {
        public String getName();

        public void run(DelayedTaskManager var1);
    }
}

