/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.metro.api.config.management;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.Reconfigurable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ThrowableContainerPropertySet;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.ReconfigNotifier;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.wsdl.OperationDispatcher;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.WebServiceException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.glassfish.gmbal.ManagedObjectManager;
import org.w3c.dom.Element;

public class ManagedEndpoint<T>
extends WSEndpoint<T> {
    private static final Logger LOGGER = Logger.getLogger(ManagedEndpoint.class);
    private WSEndpoint<T> endpointDelegate;
    private final Collection<ReconfigNotifier> reconfigNotifiers = new LinkedList<ReconfigNotifier>();
    private static final long ENDPOINT_DISPOSE_DELAY_DEFAULT = 120000L;
    private long endpointDisposeDelay = 120000L;
    private volatile ScheduledExecutorService executorService;
    private final EndpointCreationAttributes creationAttributes;
    private boolean useContainerSpi = true;
    private final AtomicBoolean isClosed;

    public ManagedEndpoint(WSEndpoint<T> endpoint, EndpointCreationAttributes attributes) {
        this.creationAttributes = attributes;
        this.endpointDelegate = endpoint;
        this.isClosed = new AtomicBoolean(false);
        for (ReconfigNotifier notifier : this.reconfigNotifiers) {
            notifier.sendNotification();
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(ManagementMessages.WSM_5066_STARTING_ENDPOINT());
        }
    }

    public void addNotifier(ReconfigNotifier notifier) {
        this.reconfigNotifiers.add(notifier);
    }

    public EndpointCreationAttributes getCreationAttributes() {
        return this.creationAttributes;
    }

    public synchronized void swapEndpointDelegate(WSEndpoint<T> endpoint) {
        Set endpointComponents = endpoint.getComponents();
        WSEndpoint<T> oldEndpoint = this.endpointDelegate;
        this.endpointDelegate = endpoint;
        for (Component component : endpointComponents) {
            Reconfigurable reconfigurable = (Reconfigurable)component.getSPI(Reconfigurable.class);
            if (reconfigurable == null) continue;
            reconfigurable.reconfigure();
        }
        this.disposeDelegate(oldEndpoint);
        LOGGER.info(ManagementMessages.WSM_5000_RECONFIGURED_ENDPOINT((Object)this));
    }

    public synchronized void dispose() {
        this.isClosed.compareAndSet(false, true);
        if (!this.useContainerSpi && this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.endpointDelegate != null) {
            this.endpointDelegate.dispose();
        }
    }

    public Codec createCodec() {
        return this.endpointDelegate.createCodec();
    }

    public QName getServiceName() {
        return this.endpointDelegate.getServiceName();
    }

    public QName getPortName() {
        return this.endpointDelegate.getPortName();
    }

    public Class<T> getImplementationClass() {
        return this.endpointDelegate.getImplementationClass();
    }

    public WSBinding getBinding() {
        return this.endpointDelegate.getBinding();
    }

    public Container getContainer() {
        return this.endpointDelegate.getContainer();
    }

    public WSDLPort getPort() {
        return this.endpointDelegate.getPort();
    }

    public void setExecutor(Executor exec) {
        this.endpointDelegate.setExecutor(exec);
    }

    public void schedule(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.schedule(request, callback, interceptor);
    }

    public void process(Packet request, WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        this.endpointDelegate.process(request, callback, interceptor);
    }

    public WSEndpoint.PipeHead createPipeHead() {
        return this.endpointDelegate.createPipeHead();
    }

    public ServiceDefinition getServiceDefinition() {
        return this.endpointDelegate.getServiceDefinition();
    }

    @NotNull
    public Set<Component> getComponents() {
        return this.endpointDelegate.getComponents();
    }

    public SEIModel getSEIModel() {
        return this.endpointDelegate.getSEIModel();
    }

    public PolicyMap getPolicyMap() {
        return this.endpointDelegate.getPolicyMap();
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.endpointDelegate.getManagedObjectManager();
    }

    public void closeManagedObjectManager() {
        this.endpointDelegate.closeManagedObjectManager();
    }

    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.endpointDelegate.getAssemblerContext();
    }

    private void disposeDelegate(final WSEndpoint<T> endpoint) {
        Runnable dispose = new Runnable(){
            final WSEndpoint<T> disposableEndpoint;
            {
                this.disposableEndpoint = endpoint;
            }

            @Override
            public void run() {
                try {
                    this.disposableEndpoint.dispose();
                }
                catch (WebServiceException e) {
                    LOGGER.severe(ManagementMessages.WSM_5101_DISPOSE_FAILED(), (Throwable)e);
                }
            }
        };
        this.getExecutorService().schedule(dispose, this.endpointDisposeDelay, TimeUnit.MILLISECONDS);
    }

    public boolean equalsProxiedInstance(WSEndpoint endpoint) {
        if (this.endpointDelegate == null) {
            return endpoint == null;
        }
        if (endpoint instanceof ManagedEndpoint) {
            return false;
        }
        return this.endpointDelegate.equals((Object)endpoint);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, String wsdlAddress, Element ... referenceParameters) {
        return (T)this.endpointDelegate.getEndpointReference(clazz, address, wsdlAddress, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, String wsdlAddress, List<Element> metadata, List<Element> referenceParameters) {
        return (T)this.endpointDelegate.getEndpointReference(clazz, address, wsdlAddress, metadata, referenceParameters);
    }

    public OperationDispatcher getOperationDispatcher() {
        return this.endpointDelegate.getOperationDispatcher();
    }

    public Packet createServiceResponseForException(ThrowableContainerPropertySet tcps, Packet packet, SOAPVersion soapv, WSDLPort wsdlp, SEIModel seim, WSBinding wsb) {
        return this.endpointDelegate.createServiceResponseForException(tcps, packet, soapv, wsdlp, seim, wsb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            ManagedEndpoint managedEndpoint = this;
            synchronized (managedEndpoint) {
                if (this.executorService == null) {
                    if (this.getContainer() != null) {
                        this.executorService = (ScheduledExecutorService)this.getContainer().getSPI(ScheduledExecutorService.class);
                    }
                    if (this.executorService == null) {
                        LOGGER.finer("Container did not return SPI for ScheduledExecutorService - creating thread pool for dispose");
                        this.executorService = Executors.newScheduledThreadPool(this.getThreadPoolSize());
                        this.useContainerSpi = false;
                    } else {
                        LOGGER.finer("Using Container SPI for ScheduledExecutorService for dispose");
                        this.useContainerSpi = true;
                    }
                    this.isClosed.set(false);
                }
            }
        }
        return this.executorService;
    }

    private int getThreadPoolSize() {
        return 1;
    }
}

