/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.api.ha.StickyFeature;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final String SC_LOCAL_NAME = "SecureConversationToken";
    private static final String NONCE_LOCAL_NAME = "HashPassword";
    private static final Set<QName> STICKINESS_ENABLERS = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(new QName(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri, "SecureConversationToken"), new QName(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri, "SecureConversationToken"), new QName(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri, "HashPassword"), new QName(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri, "HashPassword"))));

    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        SecurityStickyFeature stickyFeature = null;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key)) != null) {
            for (AssertionSet alternative : policy) {
                stickyFeature = this.resolveStickiness(alternative.iterator(), stickyFeature);
                List<WebServiceFeature> singleAlternativeFeatures = this.getFeatures(alternative);
                if (singleAlternativeFeatures.isEmpty()) continue;
                features.addAll(singleAlternativeFeatures);
            }
        }
        if (stickyFeature != null) {
            features.add(stickyFeature);
        }
        return features;
    }

    private SecurityStickyFeature resolveStickiness(Iterator<PolicyAssertion> assertions, SecurityStickyFeature currentFeature) {
        while (assertions.hasNext()) {
            PolicyAssertion assertion = assertions.next();
            if (STICKINESS_ENABLERS.contains(assertion.getName())) {
                if (currentFeature == null) {
                    currentFeature = new SecurityStickyFeature();
                }
                if (SC_LOCAL_NAME.equals(assertion.getName().getLocalPart())) {
                    currentFeature.scUsed();
                }
                if (NONCE_LOCAL_NAME.equals(assertion.getName().getLocalPart())) {
                    currentFeature.nonceManagerUsed();
                }
            }
            if (assertion.hasParameters()) {
                currentFeature = this.resolveStickiness(assertion.getParametersIterator(), currentFeature);
            }
            if (!assertion.hasNestedPolicy()) continue;
            currentFeature = this.resolveStickiness(assertion.getNestedPolicy().getAssertionSet().iterator(), currentFeature);
        }
        return currentFeature;
    }

    private List<WebServiceFeature> getFeatures(AssertionSet alternative) {
        return Collections.emptyList();
    }

    public static final class SecurityStickyFeature
    extends WebServiceFeature
    implements StickyFeature {
        public static final String ID = SecurityStickyFeature.class.getName();
        private boolean nonceManagerUsed;
        private boolean scUsed;

        public String getID() {
            return ID;
        }

        public boolean isNonceManagerUsed() {
            return this.nonceManagerUsed;
        }

        public void nonceManagerUsed() {
            this.nonceManagerUsed = true;
        }

        public boolean isScUsed() {
            return this.scUsed;
        }

        public void scUsed() {
            this.scUsed = true;
        }
    }
}

