/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public int available() {
        return this.byteBuffer.remaining();
    }

    public void close() {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        if (length > this.available()) {
            length = this.available();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }
}

