/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.impl.misc.NonceCache;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="per-endpoint NonceManager")
@AMXMetadata(type="WSNonceManager")
public class DefaultNonceManager
extends NonceManager {
    private static final boolean USE_DAEMON_THREAD = true;
    private static final Timer nonceCleanupTimer = new Timer(true);
    private NonceCache nonceCache = null;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    @ManagedAttribute
    private NonceCache getNonceCache() {
        return this.nonceCache;
    }

    public boolean validateNonce(String nonce, String created) throws NonceManager.NonceException {
        if (this.nonceCache == null || this.nonceCache != null && this.nonceCache.wasCanceled()) {
            this.initNonceCache(this.getMaxNonceAge());
        }
        if (!this.nonceCache.isScheduled()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "About to Store a new Nonce, but Reclaimer not Scheduled, so scheduling one" + this.nonceCache);
            }
            this.setNonceCacheCleanup();
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    private synchronized void setNonceCacheCleanup() {
        if (!this.nonceCache.isScheduled()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Scheduling Nonce Reclaimer task...... for " + (Object)((Object)this) + ":" + this.nonceCache);
            }
            nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getMaxNonceAge(), this.nonceCache.getMaxNonceAge());
            this.nonceCache.scheduled(true);
        }
    }

    private synchronized void initNonceCache(long maxNonceAge) {
        if (this.nonceCache == null) {
            this.nonceCache = new NonceCache(maxNonceAge);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Creating NonceCache for first time....." + this.nonceCache);
            }
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = new NonceCache(maxNonceAge);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Re-creating NonceCache because it was canceled....." + this.nonceCache);
            }
        }
    }
}

