/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.AbstractCreatorProcessor;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.api.tokens.UsernameToken;
import com.sun.xml.ws.security.opt.impl.incoming.processor.UsernameTokenProcessor;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamReaderFactory;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenHeader
implements UsernameToken,
SecurityHeaderElement,
TokenValidator,
PolicyBuilder,
NamespaceContextInfo,
SecurityElementWriter {
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");
    private String localPart = null;
    private String namespaceURI = null;
    private String id = "";
    private XMLStreamBuffer mark = null;
    private UsernameTokenProcessor filter = new UsernameTokenProcessor();
    private AuthenticationTokenPolicy.UsernameTokenBinding utPolicy = null;
    private HashMap<String, String> nsDecls;

    public UsernameTokenHeader(XMLStreamReader reader, StreamReaderBufferCreator creator, HashMap nsDecls, XMLInputFactory staxIF) throws XMLStreamException, XMLStreamBufferException {
        this.localPart = reader.getLocalName();
        this.namespaceURI = reader.getNamespaceURI();
        this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        this.mark = new XMLStreamBufferMark((Map)nsDecls, (AbstractCreatorProcessor)creator);
        XMLStreamReader utReader = XMLStreamReaderFactory.createFilteredXMLStreamReader(reader, this.filter);
        creator.createElementFragment(utReader, true);
        this.nsDecls = nsDecls;
        this.utPolicy = new AuthenticationTokenPolicy.UsernameTokenBinding();
        this.utPolicy.setUUID(this.id);
        this.utPolicy.setUsername(this.filter.getUsername());
        this.utPolicy.setPassword(this.filter.getPassword());
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.filter.getPasswordType())) {
            this.utPolicy.setDigestOn(true);
        }
        if (this.filter.getNonce() != null) {
            this.utPolicy.setUseNonce(true);
        }
        if (this.filter.getCreated() != null) {
            this.utPolicy.setUseCreated(true);
        }
    }

    @Override
    public void validate(ProcessingContext context) throws XWSSecurityException {
        boolean authenticated = false;
        if (this.filter.getPassword() == null && this.filter.getPasswordDigest() == null) {
            this.utPolicy.setNoPassword(true);
        }
        if (this.filter.getSalt() != null) {
            this.utPolicy.setNoPassword(false);
        }
        if (this.filter.getPassword() == null && this.filter.getCreated() == null && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.filter.getPasswordType())) {
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Cannot validate Password Digest since Creation Time was not Specified", null);
        }
        if (this.filter.getNonce() != null || this.filter.getCreated() != null) {
            this.validateNonceOrCreated(context);
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.filter.getPasswordType())) {
            authenticated = context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), this.filter.getUsername(), this.filter.getPasswordDigest(), this.filter.getNonce(), this.filter.getCreated());
            if (!authenticated) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1408_FAILED_SENDER_AUTHENTICATION());
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Authentication of Username Password Token Failed", null);
            }
        } else if (this.filter.getPassword() != null && !(authenticated = context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), this.filter.getUsername(), this.filter.getPassword()))) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1408_FAILED_SENDER_AUTHENTICATION());
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Authentication of Username Password Token Failed", null);
        }
        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject((FilterProcessingContext)context), this.filter.getUsername(), this.filter.getPassword());
    }

    @Override
    public WSSPolicy getPolicy() {
        return this.utPolicy;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localPart;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.mark.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.mark.writeToXMLStreamWriter(streamWriter);
    }

    @Override
    public String getUsernameValue() {
        return this.filter.getUsername();
    }

    @Override
    public void setUsernameValue(String username) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPasswordValue() {
        return this.filter.getPassword();
    }

    @Override
    public void setPasswordValue(String passwd) {
        throw new UnsupportedOperationException();
    }

    public void setSalt(String receivedSalt) {
        throw new UnsupportedOperationException();
    }

    public String getSalt() {
        return this.filter.getSalt();
    }

    public void setIterations(int iterate) {
        throw new UnsupportedOperationException();
    }

    public String getIterations() {
        return this.filter.getIterations();
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    private void validateNonceOrCreated(ProcessingContext context) throws XWSSecurityException {
        if (this.filter.getCreated() != null) {
            context.getSecurityEnvironment().validateCreationTime(context.getExtraneousProperties(), this.filter.getCreated(), 300000L, 300000L);
        }
        if (this.filter.getNonce() != null) {
            try {
                if (!context.getSecurityEnvironment().validateAndCacheNonce(context.getExtraneousProperties(), this.filter.getNonce(), this.filter.getCreated(), 900000L)) {
                    XWSSecurityException xwse = new XWSSecurityException("Invalid/Repeated Nonce value for Username Token");
                    throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", xwse);
                }
            }
            catch (NonceManager.NonceException ex) {
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", (Throwable)((Object)ex));
            }
        }
    }
}

