/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.internal.BranchRecord;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import com.sun.xml.ws.tx.at.internal.JTAHelper;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRMPeerRecoveryDelegate;
import com.sun.xml.ws.tx.at.internal.WSATNoOpXAResource;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.dev.WSATRuntimeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.WebServiceException;

public class WSATGatewayRM
implements XAResource,
WSATRuntimeConfig.RecoveryEventListener {
    private static final Logger LOGGER = Logger.getLogger(WSATGatewayRM.class);
    private static final String WSAT = "wsat";
    private static final String OUTBOUND = "outbound";
    private static final String INBOUND = "inbound";
    private static WSATGatewayRM singleton;
    private static String resourceRegistrationName;
    private static Map<Xid, BranchRecord> branches;
    static List<Xid> pendingXids;
    private final Object currentXidLock = new Object();
    private Xid currentXid;
    static boolean isReadyForRecovery;
    public static boolean isReadyForRuntime;
    public static String txlogdir;
    static String txlogdirInbound;
    private static String txlogdirOutbound;
    static boolean isStoreInit;
    private volatile int counter = 0;
    private Map<Xid, Xid> activityXidToInternalXidMap = new HashMap<Xid, Xid>();
    private Map<Xid, Xid> internalXidToActivityXidMap = new HashMap<Xid, Xid>();

    WSATGatewayRM(String serverName) {
        resourceRegistrationName = "RM_NAME_PREFIX" + serverName;
        branches = Collections.synchronizedMap(new HashMap());
        pendingXids = Collections.synchronizedList(new ArrayList());
        singleton = this;
    }

    public static synchronized WSATGatewayRM getInstance() {
        if (singleton == null) {
            WSATGatewayRM.create("server");
        }
        return singleton;
    }

    public static synchronized WSATGatewayRM create() {
        return WSATGatewayRM.create("server");
    }

    private static synchronized WSATGatewayRM create(String serverName) {
        if (singleton == null) {
            new WSATGatewayRM(serverName);
            isReadyForRecovery = WSATGatewayRM.setupRecovery();
        }
        return singleton;
    }

    private static boolean setupRecovery() {
        if (!WSATRuntimeConfig.getInstance().isWSATRecoveryEnabled()) {
            return true;
        }
        TransactionImportManager.getInstance();
        TransactionImportManager.registerRecoveryResourceHandler(singleton);
        WSATRuntimeConfig.getInstance().setWSATRecoveryEventListener((WSATRuntimeConfig.RecoveryEventListener)singleton);
        WSATGatewayRM.setTxLogDirs();
        try {
            WSATGatewayRM.initStore();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static void initStore() throws Exception {
        if (isStoreInit) {
            return;
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("WSATGatewayRM.initStore path:" + txlogdirInbound);
        }
        WSATGatewayRM.createFile(txlogdirInbound, true);
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("WSATGatewayRM.initStore path:" + txlogdirOutbound);
        }
        WSATGatewayRM.createFile(txlogdirOutbound, true);
        isStoreInit = true;
    }

    private static File createFile(String logFilePath, boolean isDir) throws Exception {
        File file = new File(logFilePath);
        if (!file.exists()) {
            if (isDir && !file.mkdirs()) {
                throw new Exception("Could not create directory : " + file.getAbsolutePath());
            }
            if (!isDir) {
                try {
                    file.createNewFile();
                }
                catch (IOException ioe) {
                    Exception storeEx = new Exception("Could not create file : " + file.getAbsolutePath());
                    storeEx.initCause(ioe);
                    throw storeEx;
                }
            }
        }
        return file;
    }

    void recoverPendingBranches(String outboundRecoveryDir, String inboundRecoveryDir) {
        ObjectInputStream in;
        FileInputStream fis;
        int i;
        File[] files;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("recoverPendingBranches outbound directory:" + outboundRecoveryDir);
        }
        if ((files = new File(outboundRecoveryDir).listFiles()) != null) {
            for (i = 0; i < files.length; ++i) {
                try {
                    fis = new FileInputStream(files[i]);
                    in = new ObjectInputStream(fis);
                    BranchRecord branch = (BranchRecord)in.readObject();
                    branch.setTxLogLocation(files[i].getCanonicalPath());
                    branches.put(branch.getXid(), branch);
                    pendingXids.addAll(branch.getAllXids());
                    in.close();
                    continue;
                }
                catch (Throwable e) {
                    throw new WebServiceException("Failure while recovering WS-AT transaction logs outbound file:" + files[i], e);
                }
            }
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("recoverPendingBranches inbound directory:" + inboundRecoveryDir);
        }
        fis = null;
        in = null;
        files = new File(inboundRecoveryDir).listFiles();
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                try {
                    fis = new FileInputStream(files[i]);
                    in = new ObjectInputStream(fis);
                    ForeignRecoveryContext frc = (ForeignRecoveryContext)in.readObject();
                    frc.setTxLogLocation(files[i].getCanonicalPath());
                    frc.setRecovered();
                    ForeignRecoveryContextManager.getInstance().add(frc);
                    in.close();
                    continue;
                }
                catch (Throwable e) {
                    throw new WebServiceException("Failure while recovering WS-AT transaction logs inbound file:" + files[i], e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid registerWSATResource(Xid xid, XAResource wsatResource, Transaction tx) throws IllegalStateException, RollbackException, SystemException {
        BranchRecord branch;
        WSATXAResource resource;
        if (tx == null) {
            throw new IllegalStateException("Transaction " + tx + " does not exist, wsatResource=" + wsatResource);
        }
        Xid xidFromActivityMap = this.activityXidToInternalXidMap.get(xid);
        if (xidFromActivityMap != null && (resource = (WSATXAResource)(branch = this.getBranch(xidFromActivityMap)).exists(wsatResource)) != null) {
            return resource.getXid();
        }
        tx.enlistResource((XAResource)new WSATNoOpXAResource());
        Object object = this.currentXidLock;
        synchronized (object) {
            tx.enlistResource((XAResource)new WSATGatewayRMPeerRecoveryDelegate());
            ((WSATXAResource)wsatResource).setXid(this.currentXid);
            branch = this.getBranch(this.currentXid);
            branch.addSubordinate(this.currentXid, (WSATXAResource)wsatResource);
            this.activityXidToInternalXidMap.put(xid, this.currentXid);
            this.internalXidToActivityXidMap.put(this.currentXid, xid);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("registerWSATResource() xid=" + this.currentXid);
            }
        }
        return this.currentXid;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.currentXid = xid;
        WSATGatewayRM.debug("start currentXid:" + this.currentXid + " xid:" + xid);
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("start() xid=" + xid + ", flags=" + flags);
        }
        switch (flags) {
            case 0: {
                this.getOrCreateBranch(xid);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                BranchRecord branch = this.getBranch(xid);
                if (branch != null) break;
                JTAHelper.throwXAException(-4, "Attempt to resume xid " + xid + " that is not in SUSPENDED state.");
                break;
            }
            case 0x20000000: {
                JTAHelper.throwXAException(-3, "error while attempting to rollback branch" + resourceRegistrationName);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid flag:" + flags);
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("end() xid=" + xid + ", flags=" + flags);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "end: no branch info for " + xid);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int vote;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("prepare() xid=" + xid);
        }
        this.purgeActivityAndInternalXidMapEntries(xid);
        BranchRecord branch = this.getBranch(xid);
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("prepare() xid=" + xid + " branch=" + branch);
        }
        if (branch == null) {
            JTAHelper.throwXAException(-4, "prepare: no branch info for " + xid);
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("prepare() xid=" + xid);
        }
        this.persistBranchIfNecessary(branch);
        try {
            vote = branch.prepare(xid);
        }
        catch (XAException xae) {
            this.deleteBranchIfNecessary(branch);
            throw xae;
        }
        if (vote == 3) {
            this.deleteBranchIfNecessary(branch);
        }
        return vote;
    }

    private void purgeActivityAndInternalXidMapEntries(Xid xid) {
        Xid activityXid = this.internalXidToActivityXidMap.remove(xid);
        if (activityXid != null) {
            this.activityXidToInternalXidMap.remove(activityXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("commit() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "commit: no branch information for xid:" + xid);
        }
        try {
            branch.commit(xid, onePhase);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("rollback() xid=" + xid);
        }
        this.purgeActivityAndInternalXidMapEntries(xid);
        BranchRecord branch = this.getBranch(xid);
        if (branch == null) {
            JTAHelper.throwXAException(-4, "rollback: no branch info for " + xid);
        }
        try {
            branch.rollback(xid);
        }
        finally {
            this.deleteBranchIfNecessary(branch);
        }
    }

    public void recover() {
        try {
            this.recover(0x1800000);
        }
        catch (XAException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.recover(flag, null);
    }

    public Xid[] recover(int flag, String instance) throws XAException {
        boolean isDelegated;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("recover() flag=" + flag);
        }
        if (!isReadyForRecovery) {
            throw new XAException("recover call on WS-AT gateway failed due to failed initialization");
        }
        boolean bl = isDelegated = instance != null;
        if (isDelegated) {
            String delegatedtxlogdir = txlogdir + File.separator + ".." + File.separator + ".." + File.separator + instance + File.separator + WSAT + File.separator;
            WSATGatewayRM.debug("delegatedtxlogdir in recover is" + delegatedtxlogdir);
            String delegatedtxlogdirOutbound = delegatedtxlogdir + OUTBOUND + File.separator;
            String delegatedtxlogdirInbound = delegatedtxlogdir + INBOUND + File.separator;
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("recover() for delegate flag=" + flag + " delegatedtxlogdirOutbound:" + delegatedtxlogdirOutbound + ", delegatedtxlogdirInbound:" + delegatedtxlogdirInbound);
            }
            singleton.recoverPendingBranches(delegatedtxlogdirOutbound, delegatedtxlogdirInbound);
        } else if (!isReadyForRuntime) {
            try {
                singleton.initStore();
            }
            catch (Exception e) {
                XAException xaEx = new XAException("WSATGatewayRM recover call failed due to StoreException:" + e);
                xaEx.errorCode = -7;
                xaEx.initCause(e);
                throw xaEx;
            }
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("recover() for this server flag=" + flag + " txlogdirOutbound:" + txlogdirOutbound + ",txlogdirInbound:" + txlogdirInbound);
            }
            singleton.recoverPendingBranches(txlogdirOutbound, txlogdirInbound);
            isReadyForRuntime = true;
        }
        if ((flag & 0x1000000) != 0) {
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("WSAT recover(" + flag + ") returning " + pendingXids);
            }
            Xid[] xids = pendingXids.toArray(new Xid[pendingXids.size()]);
            return xids;
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("recover() returning empty array");
        }
        return new Xid[0];
    }

    static void setTxLogDirs() {
        txlogdir = WSATGatewayRM.getTxLogDir();
        WSATGatewayRM.debug("txlogdir is" + txlogdir);
        String wstxlogdir = txlogdir;
        File f = new File(txlogdir);
        wstxlogdir = f.getParent();
        WSATGatewayRM.debug("wstxlogdir is" + wstxlogdir);
        txlogdirInbound = wstxlogdir + File.separator + WSAT + File.separator + INBOUND + File.separator;
        txlogdirOutbound = wstxlogdir + File.separator + WSAT + File.separator + OUTBOUND + File.separator;
    }

    static String getTxLogDir() {
        return WSATRuntimeConfig.getInstance().getTxLogLocation();
    }

    @Override
    public void forget(Xid xid) throws XAException {
        BranchRecord branch;
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("forget() xid=" + xid);
        }
        if ((branch = this.getBranch(xid)) == null) {
            JTAHelper.throwXAException(-4, "forget: no branch info for " + xid);
        }
        this.deleteBranchIfNecessary(branch);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (!(xares instanceof WSATGatewayRM)) {
            return false;
        }
        WSATGatewayRM oxares = (WSATGatewayRM)xares;
        return this.equals(oxares);
    }

    public boolean detectedUnavailable() {
        return true;
    }

    public int getDelistFlag() {
        return 0x4000000;
    }

    private synchronized BranchRecord getOrCreateBranch(Xid xid) {
        BranchRecord branch = this.getBranch(xid);
        if (branch == null) {
            branch = new BranchRecord(xid);
            branches.put(xid, branch);
        }
        return branch;
    }

    private synchronized BranchRecord getBranch(Xid xid) {
        BranchRecord branch = branches.get(xid);
        if (branch != null && xid.getBranchQualifier() != null) {
            branch.assignBranchXid(xid);
        }
        return branch;
    }

    private void delete(BranchRecord branch) {
        this.releaseBranchRecord(branch);
        branch.cleanup();
    }

    private void persistBranchRecord(BranchRecord branch) throws IOException {
        if (!WSATRuntimeConfig.getInstance().isWSATRecoveryEnabled()) {
            return;
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("persist branch record " + branch);
        }
        String logLocation = txlogdirOutbound + File.separator + System.currentTimeMillis() + "-" + this.counter++;
        branch.setTxLogLocation(logLocation);
        FileOutputStream fos = new FileOutputStream(logLocation);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(branch);
        out.close();
        fos.flush();
        branch.setLogged(true);
    }

    private void releaseBranchRecord(BranchRecord branch) {
        String logLocation = branch.getTxLogLocation();
        if (WSATHelper.isDebugEnabled()) {
            WSATGatewayRM.debug("release branch record:" + branch + " logLocation:" + logLocation);
        }
        new File(logLocation).delete();
        branch.setLogged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBranchIfNecessary(BranchRecord branch) throws XAException {
        try {
            BranchRecord branchRecord = branch;
            synchronized (branchRecord) {
                if (!branch.isLogged()) {
                    this.persistBranchRecord(branch);
                    pendingXids.addAll(branch.getAllXids());
                }
            }
        }
        catch (IOException pse) {
            WSATGatewayRM.debug("error persisting branch " + branch + ": " + pse.toString());
            LOGGER.severe(LocalizationMessages.WSAT_4500_ERROR_PERSISTING_BRANCH_RECORD(branch.toString()), (Throwable)pse);
            JTAHelper.throwXAException(-3, "Error persisting branch " + branch, pse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBranchIfNecessary(BranchRecord branch) throws XAException {
        boolean deleted = false;
        try {
            BranchRecord branchRecord = branch;
            synchronized (branchRecord) {
                branches.remove(branch.getXid());
                pendingXids.removeAll(branch.getAllXids());
                if (branch.isLogged()) {
                    this.delete(branch);
                    deleted = true;
                }
            }
        }
        catch (Exception pse) {
            WSATGatewayRM.debug("error deleting branch record " + branch + ": " + pse.toString());
            LOGGER.severe(LocalizationMessages.WSAT_4501_ERROR_DELETING_BRANCH_RECORD(branch.toString()), (Throwable)pse);
            JTAHelper.throwXAException(-3, "Error deleting branch record " + branch, pse);
        }
    }

    public void beforeRecovery(boolean delegated, String instance) {
        WSATGatewayRM.debug("afterRecovery called, delegated:" + delegated + " instance:" + instance);
        if (!delegated) {
            return;
        }
        TransactionImportManager.getInstance();
        TransactionImportManager.registerRecoveryResourceHandler(new WSATGatewayRMPeerRecoveryDelegate(instance));
    }

    public void afterRecovery(boolean success, boolean delegated, String instance) {
        WSATGatewayRM.debug("afterRecovery called, success:" + success + " delegated:" + delegated + " instance:" + instance);
    }

    private static void debug(String msg) {
        if (WSATHelper.isDebugEnabled()) {
            Logger.getLogger(WSATGatewayRM.class).log(Level.INFO, msg);
        }
    }

    static {
        isReadyForRecovery = false;
        isReadyForRuntime = false;
        isStoreInit = false;
    }

    private final class BranchObjectHandler {
        private static final int VERSION = 1;

        private BranchObjectHandler() {
        }

        public Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
            int version = in.readInt();
            if (version != 1) {
                throw new IOException("Stream corrupted.  Invalid WS-AT gateway branch version: " + version);
            }
            BranchRecord branch = new BranchRecord();
            branch.readExternal(in);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("read WS-AT branch " + branch);
            }
            return branch;
        }

        public void writeObject(ObjectOutput out, Object o) throws IOException {
            if (!(o instanceof BranchRecord)) {
                throw new IOException("Cannot serialize class of type: " + (o == null ? null : o.getClass().toString()));
            }
            out.writeInt(1);
            BranchRecord branch = (BranchRecord)o;
            branch.writeExternal(out);
            if (WSATHelper.isDebugEnabled()) {
                WSATGatewayRM.debug("serialized WS-AT branch " + branch);
            }
        }
    }
}

