/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.transport.tcp.client.ClientConnectionSession;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ConnectionCacheFactory;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ConnectionFinder;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ContactInfo;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.OutboundConnectionCache;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelException;
import com.sun.xml.ws.transport.tcp.servicechannel.stubs.ServiceChannelWSImpl;
import com.sun.xml.ws.transport.tcp.servicechannel.stubs.ServiceChannelWSImplService;
import com.sun.xml.ws.transport.tcp.util.BindingUtils;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ChannelSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionManagementSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.SessionAbortedException;
import com.sun.xml.ws.transport.tcp.util.SessionCloseListener;
import com.sun.xml.ws.transport.tcp.util.Version;
import com.sun.xml.ws.transport.tcp.util.VersionController;
import com.sun.xml.ws.transport.tcp.util.VersionMismatchException;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class WSConnectionManager
implements ConnectionFinder<ConnectionSession>,
SessionCloseListener<ConnectionSession> {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.client");
    private static final WSConnectionManager instance = new WSConnectionManager();
    private final Map<ConnectionSession, Thread> lockedConnections = new WeakHashMap<ConnectionSession, Thread>();
    private volatile OutboundConnectionCache<ConnectionSession> connectionCache;

    public static WSConnectionManager getInstance() {
        return instance;
    }

    private WSConnectionManager() {
        ConnectionManagementSettings settings = ConnectionManagementSettings.getSettingsHolder().getClientSettings();
        int highWatermark = settings.getHighWatermark();
        int numberToReclaim = settings.getNumberToReclaim();
        int maxParallelConnections = settings.getMaxParallelConnections();
        this.connectionCache = ConnectionCacheFactory.makeBlockingOutboundConnectionCache("SOAP/TCP client side cache", highWatermark, numberToReclaim, maxParallelConnections, logger);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1044_CONNECTION_MANAGER_CLIENT_SIDE_CONNECTION_CACHE(highWatermark, maxParallelConnections, numberToReclaim));
        }
    }

    @NotNull
    public ChannelContext openChannel(@NotNull WSTCPURI uri, @NotNull WSService wsService, @NotNull WSBinding wsBinding, @NotNull Codec defaultCodec) throws InterruptedException, IOException, ServiceChannelException, VersionMismatchException {
        ConnectionSession session;
        ChannelContext channelContext;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1030_CONNECTION_MANAGER_ENTER(uri, wsService.getServiceName(), wsBinding.getBindingID(), defaultCodec.getClass().getName()));
        }
        if ((channelContext = (session = this.connectionCache.get(uri, this)).findWSServiceContextByURI(uri)) == null) {
            this.lockConnection(session);
            channelContext = session.findWSServiceContextByURI(uri);
            if (channelContext == null) {
                channelContext = this.doOpenChannel(session, uri, wsService, wsBinding, defaultCodec);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1033_CONNECTION_MANAGER_RETURN_CHANNEL_CONTEXT(channelContext.getChannelId()));
        }
        return channelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(@NotNull ChannelContext channelContext) {
        ConnectionSession connectionSession = channelContext.getConnectionSession();
        ServiceChannelWSImpl serviceChannelWSImplPort = this.getSessionServiceChannel(connectionSession);
        try {
            this.lockConnection(connectionSession);
            serviceChannelWSImplPort.closeChannel(channelContext.getChannelId());
            connectionSession.deregisterChannel(channelContext);
        }
        catch (SessionAbortedException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ServiceChannelException e) {
        }
        finally {
            this.freeConnection(connectionSession);
        }
    }

    public void lockConnection(@NotNull ConnectionSession connectionSession) throws InterruptedException, SessionAbortedException {
        ConnectionSession connectionSession2 = connectionSession;
        synchronized (connectionSession2) {
            while (true) {
                Thread thread;
                if ((thread = this.lockedConnections.get(connectionSession)) == null) {
                    this.lockedConnections.put(connectionSession, Thread.currentThread());
                    return;
                }
                if (thread.equals(Thread.currentThread())) {
                    return;
                }
                connectionSession.wait(500L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeConnection(@NotNull ConnectionSession connectionSession) {
        this.connectionCache.release(connectionSession, 0);
        ConnectionSession connectionSession2 = connectionSession;
        synchronized (connectionSession2) {
            this.lockedConnections.remove(connectionSession);
            connectionSession.notify();
        }
    }

    public void abortConnection(@NotNull ConnectionSession connectionSession) {
        this.connectionCache.close(connectionSession);
    }

    @NotNull
    public ConnectionSession createConnectionSession(@NotNull WSTCPURI tcpURI) throws VersionMismatchException, ServiceChannelException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1034_CONNECTION_MANAGER_CREATE_SESSION_ENTER(tcpURI));
            }
            Connection connection = Connection.create(tcpURI.host, tcpURI.getEffectivePort());
            WSConnectionManager.doSendMagicAndCheckVersions(connection);
            ClientConnectionSession connectionSession = new ClientConnectionSession(connection, this);
            ServiceChannelWSImplService serviceChannelWS = new ServiceChannelWSImplService();
            ServiceChannelWSImpl serviceChannelWSImplPort = serviceChannelWS.getServiceChannelWSImplPort();
            ((ConnectionSession)connectionSession).setAttribute("ServicePipeline", serviceChannelWSImplPort);
            BindingProvider bindingProvider = (BindingProvider)serviceChannelWSImplPort;
            bindingProvider.getRequestContext().put("tcpSession", connectionSession);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1035_CONNECTION_MANAGER_INITIATE_SESSION());
            }
            serviceChannelWSImplPort.initiateSession();
            return connectionSession;
        }
        catch (IOException e) {
            throw new ClientTransportException(MessagesMessages.localizableWSTCP_0015_ERROR_PROTOCOL_VERSION_EXCHANGE(), (Throwable)e);
        }
    }

    @NotNull
    private ChannelContext doOpenChannel(@NotNull ConnectionSession connectionSession, @NotNull WSTCPURI targetWSURI, @NotNull WSService wsService, @NotNull WSBinding wsBinding, @NotNull Codec defaultCodec) throws IOException, ServiceChannelException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1036_CONNECTION_MANAGER_DO_OPEN_CHANNEL_ENTER());
        }
        ServiceChannelWSImpl serviceChannelWSImplPort = this.getSessionServiceChannel(connectionSession);
        BindingUtils.NegotiatedBindingContent negotiatedContent = BindingUtils.getNegotiatedContentTypesAndParams(wsBinding);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1037_CONNECTION_MANAGER_DO_OPEN_WS_CALL(targetWSURI, negotiatedContent.negotiatedMimeTypes, negotiatedContent.negotiatedParams));
        }
        Holder negotiatedMimeTypesHolder = new Holder(negotiatedContent.negotiatedMimeTypes);
        Holder negotiatedParamsHolder = new Holder(negotiatedContent.negotiatedParams);
        int channelId = serviceChannelWSImplPort.openChannel(targetWSURI.toString(), (Holder<List<String>>)negotiatedMimeTypesHolder, (Holder<List<String>>)negotiatedParamsHolder);
        ChannelSettings settings = new ChannelSettings((List)negotiatedMimeTypesHolder.value, (List)negotiatedParamsHolder.value, channelId, wsService.getServiceName(), targetWSURI);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1038_CONNECTION_MANAGER_DO_OPEN_PROCESS_SERVER_SETTINGS(settings));
        }
        ChannelContext channelContext = new ChannelContext(connectionSession, settings);
        ChannelContext.configureCodec(channelContext, wsBinding.getSOAPVersion(), defaultCodec);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1039_CONNECTION_MANAGER_DO_OPEN_REGISTER_CHANNEL(channelContext.getChannelId()));
        }
        connectionSession.registerChannel(channelContext);
        return channelContext;
    }

    @NotNull
    private ServiceChannelWSImpl getSessionServiceChannel(@NotNull ConnectionSession connectionSession) {
        return (ServiceChannelWSImpl)connectionSession.getAttribute("ServicePipeline");
    }

    @Override
    public ConnectionSession find(ContactInfo<ConnectionSession> contactInfo, Collection<ConnectionSession> idleConnections, Collection<ConnectionSession> busyConnections) throws IOException {
        WSTCPURI wsTCPURI = (WSTCPURI)contactInfo;
        ConnectionSession lru = null;
        for (ConnectionSession connectionSession : idleConnections) {
            if (connectionSession.findWSServiceContextByURI(wsTCPURI) != null) {
                return connectionSession;
            }
            if (lru != null) continue;
            lru = connectionSession;
        }
        if (lru != null || this.connectionCache.canCreateNewConnection(contactInfo)) {
            return lru;
        }
        for (ConnectionSession connectionSession : busyConnections) {
            if (connectionSession.findWSServiceContextByURI(wsTCPURI) != null) {
                return connectionSession;
            }
            if (lru != null) continue;
            lru = connectionSession;
        }
        return lru;
    }

    @Override
    public void notifySessionClose(ConnectionSession connectionSession) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1043_CONNECTION_MANAGER_NOTIFY_SESSION_CLOSE(connectionSession.getConnection()));
        }
        this.freeConnection(connectionSession);
    }

    private static void doSendMagicAndCheckVersions(Connection connection) throws IOException, VersionMismatchException {
        VersionController versionController = VersionController.getInstance();
        Version framingVersion = versionController.getFramingVersion();
        Version connectionManagementVersion = versionController.getConnectionManagementVersion();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1040_CONNECTION_MANAGER_DO_CHECK_VERSION_ENTER(framingVersion, connectionManagementVersion));
        }
        connection.setDirectMode(true);
        OutputStream outputStream = connection.openOutputStream();
        outputStream.write("vnd.sun.ws.tcp".getBytes("US-ASCII"));
        DataInOutUtils.writeInts4(outputStream, framingVersion.getMajor(), framingVersion.getMinor(), connectionManagementVersion.getMajor(), connectionManagementVersion.getMinor());
        connection.flush();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1041_CONNECTION_MANAGER_DO_CHECK_VERSION_SENT());
        }
        InputStream inputStream = connection.openInputStream();
        int[] versionInfo = new int[4];
        DataInOutUtils.readInts4(inputStream, versionInfo, 4);
        Version serverFramingVersion = new Version(versionInfo[0], versionInfo[1]);
        Version serverConnectionManagementVersion = new Version(versionInfo[2], versionInfo[3]);
        connection.setDirectMode(false);
        boolean success = versionController.isVersionSupported(serverFramingVersion, serverConnectionManagementVersion);
        if (!success) {
            throw new VersionMismatchException(MessagesMessages.WSTCP_0006_VERSION_MISMATCH(), serverFramingVersion, serverConnectionManagementVersion);
        }
    }
}

