/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import java.io.IOException;
import javax.xml.ws.WebServiceException;

final class Utilities {
    private static final Logger LOGGER = Logger.getLogger(Utilities.class);

    private Utilities() {
    }

    static void assertSequenceId(String expected, String actual) throws IllegalStateException {
        if (expected != null && !expected.equals(actual)) {
            throw (IllegalStateException)LOGGER.logSevereException((Throwable)new IllegalStateException(LocalizationMessages.WSRM_1105_SEQUENCE_ID_NOT_RECOGNIZED(actual, expected)));
        }
    }

    static String extractSecurityContextTokenId(SecurityTokenReferenceType strType) throws RxException {
        Reference strReference = WSTrustElementFactory.newInstance().createSecurityTokenReference(new ObjectFactory().createSecurityTokenReference(strType)).getReference();
        if (!(strReference instanceof DirectReference)) {
            throw (RxException)LOGGER.logSevereException((Throwable)new RxException(LocalizationMessages.WSRM_1132_SECURITY_REFERENCE_ERROR(strReference.getClass().getName())));
        }
        return ((DirectReference)strReference).getURIAttr().toString();
    }

    static Session startSession(WSEndpoint endpoint, String sessionId) {
        SessionManager manager = SessionManager.getSessionManager((WSEndpoint)endpoint, null);
        Session session = manager.getSession(sessionId);
        if (session == null) {
            session = manager.createSession(sessionId);
        }
        return session;
    }

    static void endSessionIfExists(WSEndpoint endpoint, String sessionId) {
        SessionManager manager = SessionManager.getSessionManager((WSEndpoint)endpoint, null);
        if (manager.getSession(sessionId) != null) {
            manager.terminateSession(sessionId);
        }
    }

    static boolean isResendPossible(Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        if (throwable instanceof WebServiceException) {
            if (throwable instanceof ClientTransportException) {
                return true;
            }
            if (throwable.getCause() instanceof IOException) {
                return true;
            }
        }
        return false;
    }
}

