/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Issuer;
import com.sun.xml.ws.security.impl.policy.IssuerName;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class KerberosToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.KerberosToken,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private String tokenType = null;
    private String id = null;
    private boolean reqDK = false;
    private boolean isServer = false;
    private HashSet<String> referenceType = null;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;
    private Issuer issuer = null;
    private IssuerName issuerName = null;
    private Claims claims = null;

    public KerberosToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        this.referenceType = new HashSet();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public Set getTokenRefernceType() {
        this.populate();
        return this.referenceType;
    }

    public void addTokenReferenceType(String tokenRefType) {
        this.referenceType.add(tokenRefType);
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        this.includeToken = type;
    }

    public String getTokenId() {
        return this.id;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public IssuerName getIssuerName() {
        this.populate();
        return this.issuerName;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isTokenReferenceType(assertion, this.spVersion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isKerberosTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart().intern();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.reqDK = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "KerberosToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion;
                    assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isIssuer(assertion, this.spVersion)) {
                        this.issuer = (Issuer)assertion;
                        continue;
                    }
                    if (PolicyUtil.isIssuerName(assertion, this.spVersion)) {
                        this.issuerName = (IssuerName)assertion;
                        continue;
                    }
                    if (!PolicyUtil.isClaimsElement(assertion) || !SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri)) continue;
                    this.claims = (Claims)assertion;
                }
            }
            if (this.issuer != null && this.issuerName != null) {
                Constants.log_invalid_assertion(this.issuerName, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_INVALID_VALUE;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

