/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DerivedKeyTokenHeaderBlock
extends SecurityHeaderBlockImpl
implements Token,
SecurityToken {
    private Document contextDocument = null;
    private SecurityTokenReference securityTokenRefElement = null;
    private long offset = 0L;
    private long length = 32L;
    private String nonce = null;
    private long generation = -1L;
    private String wsuId = null;
    private String label = null;
    private byte[] decodedNonce = null;

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, DerivedKeyTokenHeaderBlock.class);
    }

    public DerivedKeyTokenHeaderBlock(Document contextDocument, SecurityTokenReference securityTokenRefElement, String wsuId) throws XWSSecurityException {
        if (securityTokenRefElement == null) {
            throw new XWSSecurityException("DerivedKeyToken can not be null");
        }
        this.contextDocument = contextDocument;
        this.securityTokenRefElement = securityTokenRefElement;
        this.wsuId = wsuId;
    }

    public DerivedKeyTokenHeaderBlock(Document contextDocument, SecurityTokenReference securityTokenRefElement, String nonce, String wsuId) throws XWSSecurityException {
        if (securityTokenRefElement == null) {
            throw new XWSSecurityException("DerivedKeyToken can not be null");
        }
        this.contextDocument = contextDocument;
        this.securityTokenRefElement = securityTokenRefElement;
        this.wsuId = wsuId;
        if (nonce == null) {
            throw new XWSSecurityException("Nonce can not be null");
        }
        this.nonce = nonce;
    }

    public DerivedKeyTokenHeaderBlock(Document contextDocument, SecurityTokenReference securityTokenRefElement, String nonce, long generation, String wsuId) throws XWSSecurityException {
        this(contextDocument, securityTokenRefElement, nonce, wsuId);
        this.generation = generation;
    }

    public DerivedKeyTokenHeaderBlock(Document contextDocument, SecurityTokenReference securityTokenRefElement, String nonce, long offset, long length, String wsuId) throws XWSSecurityException {
        this(contextDocument, securityTokenRefElement, nonce, -1L, wsuId);
        this.length = length;
        this.offset = offset;
    }

    public DerivedKeyTokenHeaderBlock(Document contextDocument, SecurityTokenReference securityTokenRefElement, String nonce, long offset, long length, String wsuId, String label) throws XWSSecurityException {
        this(contextDocument, securityTokenRefElement, nonce, -1L, wsuId);
        this.length = length;
        this.offset = offset;
        this.label = label;
    }

    public DerivedKeyTokenHeaderBlock(SOAPElement derivedKeyTokenHeaderBlock) throws XWSSecurityException {
        this.setSOAPElement(derivedKeyTokenHeaderBlock);
        this.contextDocument = this.getOwnerDocument();
        if (!"DerivedKeyToken".equals(this.getLocalName()) || !XMLUtil.inWsscNS(this)) {
            throw new SecurityTokenException("Expected DerivedKeyToken Element, but Found " + this.getPrefix() + ":" + this.getLocalName());
        }
        boolean invalidToken = false;
        Iterator children = this.getChildElements();
        String wsuId = this.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (!"".equals(wsuId)) {
            this.setId(wsuId);
        }
        Node object = null;
        boolean offsetSpecified = false;
        boolean genSpecified = false;
        boolean lenSpecified = false;
        while (children.hasNext()) {
            object = (Node)children.next();
            if (object.getNodeType() != 1) continue;
            SOAPElement element = (SOAPElement)object;
            if ("SecurityTokenReference".equals(element.getLocalName()) && XMLUtil.inWsseNS(element)) {
                this.securityTokenRefElement = new SecurityTokenReference(element);
                continue;
            }
            if ("Offset".equals(element.getLocalName())) {
                try {
                    offsetSpecified = true;
                    this.offset = Long.valueOf(element.getValue());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new XWSSecurityException((Throwable)nfe);
                }
            }
            if ("Length".equals(element.getLocalName())) {
                try {
                    lenSpecified = true;
                    this.length = Long.valueOf(element.getValue());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new XWSSecurityException((Throwable)nfe);
                }
            }
            if ("Nonce".equals(element.getLocalName())) {
                this.nonce = element.getValue();
                continue;
            }
            if ("Generation".equals(element.getLocalName())) {
                try {
                    genSpecified = true;
                    this.generation = Long.valueOf(element.getValue());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new XWSSecurityException((Throwable)nfe);
                }
            }
            if ("Label".equals(element.getLocalName())) {
                this.label = element.getValue();
                continue;
            }
            invalidToken = true;
            break;
        }
        if (offsetSpecified && genSpecified) {
            invalidToken = true;
        }
        if (invalidToken) {
            throw new XWSSecurityException("Invalid DerivedKeyToken");
        }
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.delegateElement != null) {
            return this.delegateElement;
        }
        try {
            this.setSOAPElement((SOAPElement)this.contextDocument.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:DerivedKeyToken"));
            this.addNamespaceDeclaration("wsc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
            if (this.securityTokenRefElement == null) {
                throw new SecurityTokenException("securitytokenreference was not set");
            }
            SOAPElement elem = this.securityTokenRefElement.getAsSoapElement();
            this.delegateElement.appendChild((Node)elem);
            if (this.generation == -1L) {
                this.addChildElement("Offset", "wsc").addTextNode(String.valueOf(this.offset));
                this.addChildElement("Length", "wsc").addTextNode(String.valueOf(this.length));
            } else {
                this.addChildElement("Generation", "wsc").addTextNode(String.valueOf(this.generation));
                this.addChildElement("Length", "wsc").addTextNode(String.valueOf(this.length));
            }
            if (this.label != null) {
                this.addChildElement("Label", "wsc").addTextNode(this.label);
            }
            if (this.nonce != null) {
                this.addChildElement("Nonce", "wsc").addTextNode(this.nonce);
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr((Element)((Object)this), this.wsuId);
            }
        }
        catch (SOAPException se) {
            throw new SecurityTokenException("There was an error creating DerivedKey Token " + se.getMessage());
        }
        return super.getAsSoapElement();
    }

    public Document getContextDocument() {
        return this.contextDocument;
    }

    public byte[] getNonce() {
        if (this.decodedNonce != null) {
            return this.decodedNonce;
        }
        try {
            this.decodedNonce = Base64.decode(this.nonce);
        }
        catch (Base64DecodingException bde) {
            throw new RuntimeException(bde);
        }
        return this.decodedNonce;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public SecurityTokenReference getDerivedKeyElement() {
        return this.securityTokenRefElement;
    }

    public String getType() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
    }

    public Object getTokenValue() {
        return this;
    }

    private void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    public String getLabel() {
        return this.label;
    }
}

