/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.client;

import com.oracle.webservices.api.message.BasePropertySet;
import com.oracle.webservices.api.message.PropertySet;
import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.DistributedPropertySet;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.io.DataInOutUtils;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TCPClientTransport
extends DistributedPropertySet {
    private ChannelContext channelContext;
    private Connection connection;
    private InputStream inputStream;
    private OutputStream outputStream;
    private int status;
    private String contentType;
    private WSTCPError error;
    private static final BasePropertySet.PropertyMap model = TCPClientTransport.parse(TCPClientTransport.class);

    public TCPClientTransport() {
    }

    public TCPClientTransport(@NotNull ChannelContext channelContext) {
        this.setup(channelContext);
    }

    public void setup(@Nullable ChannelContext channelContext) {
        this.channelContext = channelContext;
        if (channelContext != null) {
            this.connection = channelContext.getConnection();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @NotNull
    public OutputStream openOutputStream() throws IOException, WSTCPException {
        this.connection.setChannelId(this.channelContext.getChannelId());
        this.connection.setMessageId(0);
        this.channelContext.setContentType(this.contentType);
        this.outputStream = this.connection.openOutputStream();
        return this.outputStream;
    }

    @NotNull
    public InputStream openInputStream() throws IOException, WSTCPException {
        this.connection.prepareForReading();
        this.inputStream = this.connection.openInputStream();
        int messageId = this.connection.getMessageId();
        this.status = this.convertToReplyStatus(messageId);
        if (FrameType.isFrameContainsParams(messageId)) {
            this.contentType = this.channelContext.getContentType();
        }
        if (this.status == 2) {
            this.error = this.parseErrorMessagePayload();
        }
        return this.inputStream;
    }

    public void send() throws IOException {
        this.connection.flush();
    }

    public void close() {
        this.error = null;
    }

    public void setContentType(@NotNull String contentType) {
        this.contentType = contentType;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public WSTCPError getError() {
        return this.error;
    }

    @Nullable
    private WSTCPError parseErrorMessagePayload() throws IOException {
        int[] params = new int[3];
        DataInOutUtils.readInts4(this.inputStream, params, 3);
        int errorCode = params[0];
        int errorSubCode = params[1];
        int errorDescriptionBufferLength = params[2];
        byte[] errorDescriptionBuffer = new byte[errorDescriptionBufferLength];
        DataInOutUtils.readFully(this.inputStream, errorDescriptionBuffer);
        String errorDescription = new String(errorDescriptionBuffer, "UTF-8");
        return WSTCPError.createError(errorCode, errorSubCode, errorDescription);
    }

    private int convertToReplyStatus(int messageId) {
        if (messageId == 5) {
            return 1;
        }
        if (messageId == 4) {
            return 2;
        }
        return 0;
    }

    @PropertySet.Property(value={"channelContext"})
    public ChannelContext getConnectionContext() {
        return this.channelContext;
    }

    public BasePropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    public SOAPMessage getSOAPMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public void setSOAPMessage(SOAPMessage soap) {
        throw new UnsupportedOperationException();
    }
}

