/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.IssuerName;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class IssuedToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.IssuedToken,
SecurityAssertionValidator {
    private boolean populated = false;
    private RequestSecurityTokenTemplate rstTemplate;
    private Issuer issuer = null;
    private IssuerName issuerName = null;
    private ArrayList<String> referenceType;
    private String id;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean reqDK = false;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;
    private Claims claims = null;

    public IssuedToken() {
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public IssuedToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public RequestSecurityTokenTemplate getRequestSecurityTokenTemplate() {
        this.populate();
        return this.rstTemplate;
    }

    @Override
    public Iterator getTokenRefernceType() {
        this.populate();
        return this.referenceType.iterator();
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public IssuerName getIssuerName() {
        this.populate();
        return this.issuerName;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isIssuer(assertion, this.spVersion)) {
                        this.issuer = (Issuer)assertion;
                        continue;
                    }
                    if (PolicyUtil.isRequestSecurityTokenTemplate(assertion, this.spVersion)) {
                        this.rstTemplate = (RequestSecurityTokenTemplate)assertion;
                        continue;
                    }
                    if (PolicyUtil.isIssuerName(assertion, this.spVersion)) {
                        this.issuerName = (IssuerName)assertion;
                        continue;
                    }
                    if (PolicyUtil.isClaimsElement(assertion) && SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri)) {
                        this.claims = (Claims)assertion;
                        continue;
                    }
                    if (assertion.isOptional()) continue;
                    Constants.log_invalid_assertion(assertion, isServer, "IssuedToken");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            if (this.issuer != null && this.issuerName != null) {
                Constants.log_invalid_assertion(this.issuerName, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_INVALID_VALUE;
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            if (as == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, " Nested Policy is empty");
                }
                this.populated = true;
                return this.fitness;
            }
            for (PolicyAssertion assertion : as) {
                if (this.referenceType == null) {
                    this.referenceType = new ArrayList();
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.reqDK = true;
                    continue;
                }
                if (PolicyUtil.isRequireExternalReference(assertion, this.spVersion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isRequireInternalReference(assertion, this.spVersion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "IssuedToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

