/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.policy;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.transport.tcp.SelectOptimalTransportFeature;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class OptimalTransportPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(OptimalTransportPolicyMapConfigurator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LinkedList<PolicySubject> subjects = new LinkedList<PolicySubject>();
        try {
            LOGGER.entering(new Object[]{policyMap, model, wsBinding});
            this.updateOptimalTransportSettings(subjects, wsBinding, model, policyMap);
            LinkedList<PolicySubject> linkedList = subjects;
            return linkedList;
        }
        finally {
            LOGGER.exiting(subjects);
        }
    }

    private void updateOptimalTransportSettings(Collection<PolicySubject> subjects, WSBinding wsBinding, SEIModel model, PolicyMap policyMap) throws PolicyException, IllegalArgumentException {
        Policy existingPolicy;
        SelectOptimalTransportFeature optimalTransportFeature = (SelectOptimalTransportFeature)wsBinding.getFeature(SelectOptimalTransportFeature.class);
        if (optimalTransportFeature == null || !optimalTransportFeature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Make Optimal transport feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)model.getServiceQName(), (QName)model.getPortName());
        Policy policy = existingPolicy = policyMap != null ? policyMap.getEndpointEffectivePolicy(endpointKey) : null;
        if (existingPolicy == null || !existingPolicy.contains(TCPConstants.SELECT_OPTIMAL_TRANSPORT_ASSERTION)) {
            Policy otPolicy = this.createOptimalTransportPolicy(model.getBoundPortTypeName());
            WsdlBindingSubject wsdlSubject = WsdlBindingSubject.createBindingSubject((QName)model.getBoundPortTypeName());
            PolicySubject subject = new PolicySubject((Object)wsdlSubject, otPolicy);
            subjects.add(subject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Added Optimal transport policy with ID '%s' to binding element '%s'", otPolicy.getIdOrName(), model.getBoundPortTypeName()));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Make Optimal transport assertion is already present in the endpoint policy");
        }
    }

    private Policy createOptimalTransportPolicy(QName bindingName) {
        return Policy.createPolicy(null, (String)(bindingName.getLocalPart() + "_OptimalTransport_Policy"), List.of(AssertionSet.createAssertionSet(List.of(new OptimalTransportAssertion()))));
    }

    public static class OptimalTransportAssertion
    extends SimpleAssertion {
        public OptimalTransportAssertion() {
            this(AssertionData.createAssertionData((QName)TCPConstants.SELECT_OPTIMAL_TRANSPORT_ASSERTION), null);
        }

        public OptimalTransportAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters) {
            super(data, assertionParameters);
        }
    }
}

