/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx.elements;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.PolicyReference;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.elements.DelegateTo;
import com.sun.xml.ws.security.trust.elements.Encryption;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Issuer;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.ProofEncryption;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.SignChallenge;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.AllowPostdatingType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ClaimsType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.DelegateToType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EncryptionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.LifetimeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.OnBehalfOfType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ProofEncryptionType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RenewingType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.SecondaryParametersType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.SignChallengeType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.UseKeyType;
import com.sun.xml.ws.security.trust.impl.wssx.elements.AllowPostdatingImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinaryExchangeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.DelegateToImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EncryptionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.ProofEncryptionImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.RenewingImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.SignChallengeImpl;
import com.sun.xml.ws.security.trust.impl.wssx.elements.UseKeyImpl;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class SecondaryParametersImpl
extends SecondaryParametersType
implements SecondaryParameters {
    private Claims claims = null;
    private URI tokenType = null;
    private long keySize = 0L;
    private URI keyType = null;
    private URI computedKeyAlgorithm = null;
    private URI signWith = null;
    private URI encryptWith = null;
    private URI authenticationType = null;
    private URI signatureAlgorithm = null;
    private URI encryptionAlgorithm = null;
    private URI canonAlgorithm = null;
    private URI keyWrapAlgorithm = null;
    private Lifetime lifetime = null;
    private Entropy entropy = null;
    private AppliesTo appliesTo = null;
    private OnBehalfOf obo = null;
    private SignChallenge signChallenge = null;
    private Encryption encryption = null;
    private UseKey useKey = null;
    private DelegateTo delegateTo = null;
    private AllowPostdating apd = null;
    private BinaryExchange binaryExchange = null;
    private Issuer issuer = null;
    private Renewing renewable = null;
    private ProofEncryption proofEncryption = null;
    private boolean forwardable = true;
    private boolean delegatable = false;
    private Policy policy = null;
    private PolicyReference policyRef = null;

    public SecondaryParametersImpl() {
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
        JAXBElement<ClaimsType> cElement = new ObjectFactory().createClaims((ClaimsType)claims);
        this.getAny().add(cElement);
    }

    public Claims getClaims() {
        return this.claims;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(URI tokenType) {
        if (tokenType != null) {
            this.tokenType = tokenType;
            JAXBElement<String> ttElement = new ObjectFactory().createTokenType(tokenType.toString());
            this.getAny().add(ttElement);
        }
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        JAXBElement<LifetimeType> ltElement = new ObjectFactory().createLifetime((LifetimeType)lifetime);
        this.getAny().add(ltElement);
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public void setEntropy(Entropy entropy) {
        this.entropy = entropy;
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)entropy);
        this.getAny().add(etElement);
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.getAny().add(appliesTo);
        this.appliesTo = appliesTo;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setOnBehalfOf(OnBehalfOf onBehalfOf) {
        this.obo = onBehalfOf;
    }

    public OnBehalfOf getOnBehalfOf() {
        return this.obo;
    }

    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setRenewable(Renewing renew) {
        this.renewable = renew;
        JAXBElement<RenewingType> renewType = new ObjectFactory().createRenewing((RenewingType)renew);
        this.getAny().add(renewType);
    }

    public Renewing getRenewable() {
        return this.renewable;
    }

    public void setSignChallenge(SignChallenge challenge) {
        this.signChallenge = challenge;
        JAXBElement<SignChallengeType> challengeType = new ObjectFactory().createSignChallenge((SignChallengeType)challenge);
        this.getAny().add(challengeType);
    }

    public SignChallenge getSignChallenge() {
        return this.signChallenge;
    }

    public void setBinaryExchange(BinaryExchange exchange) {
        this.binaryExchange = exchange;
        JAXBElement<BinaryExchangeType> exchangeType = new ObjectFactory().createBinaryExchange((BinaryExchangeType)exchange);
        this.getAny().add(exchangeType);
    }

    public BinaryExchange getBinaryExchange() {
        return this.binaryExchange;
    }

    public void setAuthenticationType(URI uri) {
        this.authenticationType = uri;
        JAXBElement<String> atElement = new ObjectFactory().createAuthenticationType(uri.toString());
        this.getAny().add(atElement);
    }

    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    public void setKeyType(URI keytype) throws WSTrustException {
        this.keyType = keytype;
        JAXBElement<String> ktElement = new ObjectFactory().createKeyType(this.keyType.toString());
        this.getAny().add(ktElement);
    }

    public URI getKeyType() {
        return this.keyType;
    }

    public void setKeySize(long size) {
        this.keySize = size;
        JAXBElement<Long> ksElement = new ObjectFactory().createKeySize(size);
        this.getAny().add(ksElement);
    }

    public long getKeySize() {
        return this.keySize;
    }

    public void setSignatureAlgorithm(URI algorithm) {
        this.signatureAlgorithm = algorithm;
        JAXBElement<String> signElement = new ObjectFactory().createSignatureAlgorithm(algorithm.toString());
        this.getAny().add(signElement);
    }

    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setEncryptionAlgorithm(URI algorithm) {
        this.encryptionAlgorithm = algorithm;
        JAXBElement<String> encElement = new ObjectFactory().createEncryptionAlgorithm(algorithm.toString());
        this.getAny().add(encElement);
    }

    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setCanonicalizationAlgorithm(URI algorithm) {
        this.canonAlgorithm = algorithm;
        JAXBElement<String> canonElement = new ObjectFactory().createCanonicalizationAlgorithm(algorithm.toString());
        this.getAny().add(canonElement);
    }

    public URI getCanonicalizationAlgorithm() {
        return this.canonAlgorithm;
    }

    public void setUseKey(UseKey useKey) {
        this.useKey = useKey;
        JAXBElement<UseKeyType> ukElement = new ObjectFactory().createUseKey((UseKeyType)useKey);
        this.getAny().add(ukElement);
    }

    public UseKey getUseKey() {
        return this.useKey;
    }

    public void setProofEncryption(ProofEncryption proofEncryption) {
        this.proofEncryption = proofEncryption;
        JAXBElement<ProofEncryptionType> proofElement = new ObjectFactory().createProofEncryption((ProofEncryptionType)proofEncryption);
        this.getAny().add(proofElement);
    }

    public ProofEncryption getProofEncryption() {
        return this.proofEncryption;
    }

    public void setComputedKeyAlgorithm(URI algorithm) {
        if (algorithm != null) {
            String ckaString = algorithm.toString();
            if (!ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKHASHalgorithmURI()) && !ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKPSHA1algorithmURI())) {
                throw new RuntimeException("Invalid Computed Key Algorithm specified");
            }
            this.computedKeyAlgorithm = algorithm;
            JAXBElement<String> ckaElement = new ObjectFactory().createComputedKeyAlgorithm(ckaString);
            this.getAny().add(ckaElement);
        }
    }

    public URI getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    public void setEncryption(Encryption enc) {
        this.encryption = enc;
        JAXBElement<EncryptionType> encElement = new ObjectFactory().createEncryption((EncryptionType)enc);
        this.getAny().add(encElement);
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setSignWith(URI algorithm) {
        this.signWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createSignWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getSignWith() {
        return this.signWith;
    }

    public void setEncryptWith(URI algorithm) {
        this.encryptWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createEncryptWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getEncryptWith() {
        return this.encryptWith;
    }

    public void setKeyWrapAlgorithm(URI algorithm) {
        this.keyWrapAlgorithm = algorithm;
        JAXBElement<String> keyWrapElement = new ObjectFactory().createKeyWrapAlgorithm(algorithm.toString());
        this.getAny().add(keyWrapElement);
    }

    public URI getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    public void setDelegateTo(DelegateTo to) {
        this.delegateTo = to;
        JAXBElement<DelegateToType> dtElement = new ObjectFactory().createDelegateTo((DelegateToType)to);
        this.getAny().add(dtElement);
    }

    public DelegateTo getDelegateTo() {
        return this.delegateTo;
    }

    public void setForwardable(boolean flag) {
        this.forwardable = flag;
        JAXBElement<Boolean> forward = new ObjectFactory().createForwardable(flag);
        this.getAny().add(forward);
    }

    public boolean getForwardable() {
        return this.forwardable;
    }

    public void setDelegatable(boolean flag) {
        this.delegatable = flag;
        JAXBElement<Boolean> del = new ObjectFactory().createDelegatable(flag);
        this.getAny().add(del);
    }

    public boolean getDelegatable() {
        return this.delegatable;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
        this.getAny().add(policy);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicyReference(PolicyReference policyRef) {
        this.policyRef = policyRef;
        this.getAny().add(policyRef);
    }

    public PolicyReference getPolicyReference() {
        return this.policyRef;
    }

    public AllowPostdating getAllowPostdating() {
        return this.apd;
    }

    public void setAllowPostdating(AllowPostdating allowPostdating) {
        this.apd = allowPostdating;
        JAXBElement<AllowPostdatingType> allowPd = new ObjectFactory().createAllowPostdating((AllowPostdatingType)this.apd);
        this.getAny().add(allowPd);
    }

    public SecondaryParametersImpl(SecondaryParametersType spType) throws Exception {
        List<Object> list = spType.getAny();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof AppliesTo) {
                this.setAppliesTo((AppliesTo)list.get(i));
                continue;
            }
            if (!(list.get(i) instanceof JAXBElement)) continue;
            JAXBElement obj = (JAXBElement)list.get(i);
            String local = obj.getName().getLocalPart();
            if (local.equalsIgnoreCase("KeySize")) {
                this.setKeySize((Long)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("KeyType")) {
                this.setKeyType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("ComputedKeyAlgorithm")) {
                this.setComputedKeyAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("TokenType")) {
                this.setTokenType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("AuthenticationType")) {
                this.setAuthenticationType(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("Lifetime")) {
                LifetimeType ltType = (LifetimeType)obj.getValue();
                this.setLifetime(new LifetimeImpl(ltType.getCreated(), ltType.getExpires()));
                continue;
            }
            if (local.equalsIgnoreCase("Entropy")) {
                EntropyType eType = (EntropyType)obj.getValue();
                this.setEntropy(new EntropyImpl(eType));
                continue;
            }
            if (local.equalsIgnoreCase("Forwardable")) {
                this.setForwardable((Boolean)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("Delegatable")) {
                this.setDelegatable((Boolean)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("SignWith")) {
                this.setSignWith(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("EncryptWith")) {
                this.setEncryptWith(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("SignatureAlgorithm")) {
                this.setSignatureAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("EncryptionAlgorithm")) {
                this.setEncryptionAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                this.setCanonicalizationAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("KeyWrapAlgorithm")) {
                this.setKeyWrapAlgorithm(new URI((String)obj.getValue()));
                continue;
            }
            if (local.equalsIgnoreCase("AllowPostdating")) {
                this.setAllowPostdating(new AllowPostdatingImpl());
                continue;
            }
            if (local.equalsIgnoreCase("SignChallenge")) {
                this.setSignChallenge(new SignChallengeImpl());
                continue;
            }
            if (local.equalsIgnoreCase("BinaryExchange")) {
                BinaryExchangeType bcType = (BinaryExchangeType)obj.getValue();
                this.setBinaryExchange(new BinaryExchangeImpl(bcType));
                continue;
            }
            if (local.equalsIgnoreCase("Claims")) {
                ClaimsType cType = (ClaimsType)obj.getValue();
                this.setClaims(new ClaimsImpl(cType));
                continue;
            }
            if (local.equalsIgnoreCase("Renewing")) {
                this.setRenewable(new RenewingImpl());
                continue;
            }
            if (local.equalsIgnoreCase("ProofEncryption")) {
                ProofEncryptionType peType = (ProofEncryptionType)obj.getValue();
                this.setProofEncryption(new ProofEncryptionImpl(peType));
                continue;
            }
            if (local.equalsIgnoreCase("Policy")) {
                this.setPolicy((Policy)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("PolicyReference")) {
                this.setPolicyReference((PolicyReference)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("AppliesTo")) {
                this.setAppliesTo((AppliesTo)obj.getValue());
                continue;
            }
            if (local.equalsIgnoreCase("OnBehalfOf")) {
                OnBehalfOfType oboType = (OnBehalfOfType)obj.getValue();
                this.setOnBehalfOf(new OnBehalfOfImpl(oboType));
                continue;
            }
            if (local.equalsIgnoreCase("Encryption")) {
                EncryptionType encType = (EncryptionType)obj.getValue();
                this.setEncryption(new EncryptionImpl(encType));
                continue;
            }
            if (local.equalsIgnoreCase("UseKey")) {
                UseKeyType ukType = (UseKeyType)obj.getValue();
                this.setUseKey(new UseKeyImpl(ukType));
                continue;
            }
            if (local.equalsIgnoreCase("DelegateTo")) {
                DelegateToType dtType = (DelegateToType)obj.getValue();
                this.setDelegateTo(new DelegateToImpl(dtType));
                continue;
            }
            if (!local.equalsIgnoreCase("AppliesTo")) continue;
            this.setAppliesTo((AppliesTo)obj.getValue());
        }
    }
}

