/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml11.jaxb10.Assertion;
import com.sun.xml.wss.saml.internal.saml11.jaxb10.impl.AssertionImpl;
import com.sun.xml.wss.saml.internal.saml11.jaxb20.AssertionType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssertionUtil {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    private AssertionUtil(CallbackHandler callbackHandler) {
    }

    public static Key getSubjectConfirmationKey(Element assertion, CallbackHandler callbackHandler) throws XWSSecurityException {
        NodeList nl1 = assertion.getElementsByTagName("SubjectConfirmation");
        if (nl1.getLength() == 0) {
            throw new XWSSecurityException("SAML Assertion does not contain a key");
        }
        NodeList nl = ((Element)nl1.item(0)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nl.getLength() == 0) {
            throw new XWSSecurityException("SAML Assertion does not contain a key");
        }
        try {
            Element keyInfoElem = (Element)nl.item(0);
            KeyInfo keyInfo = new KeyInfo(keyInfoElem, null);
            if (keyInfo.containsKeyValue()) {
                return keyInfo.itemKeyValue(0).getPublicKey();
            }
            if (keyInfo.containsX509Data()) {
                return AssertionUtil.resolveX509Data(keyInfo.itemX509Data(0), callbackHandler);
            }
            if (keyInfo.length("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey") > 0) {
                return AssertionUtil.resolveEncryptedKey(keyInfo.itemEncryptedKey(0), callbackHandler);
            }
            throw new XWSSecurityException("Unsupported Key Information");
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static Key resolveX509Data(X509Data x509Data, CallbackHandler callbackHandler) throws XWSSecurityException {
        x509Data.getElement().normalize();
        X509Certificate cert = null;
        try {
            if (x509Data.containsCertificate()) {
                cert = x509Data.itemCertificate(0).getX509Certificate();
            } else if (x509Data.containsSKI()) {
                byte[] keyIdentifier = x509Data.itemSKI(0).getSKIBytes();
                SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest certRequest = new SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
                SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
                Callback[] callbacks = new Callback[]{verifyKeyCallback};
                try {
                    callbackHandler.handle(callbacks);
                }
                catch (Exception e) {
                    throw new XWSSecurityException((Throwable)e);
                }
                cert = certRequest.getX509Certificate();
                if (cert == null) {
                    throw new XWSSecurityException("No Matching public key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
                }
            } else if (x509Data.containsIssuerSerial()) {
                String issuerName = x509Data.itemIssuerSerial(0).getIssuerName();
                BigInteger serialNumber = x509Data.itemIssuerSerial(0).getSerialNumber();
                SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest certRequest = new SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
                SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
                Callback[] callbacks = new Callback[]{verifyKeyCallback};
                try {
                    callbackHandler.handle(callbacks);
                }
                catch (Exception e) {
                    throw new XWSSecurityException((Throwable)e);
                }
                cert = certRequest.getX509Certificate();
                if (cert == null) {
                    throw new XWSSecurityException("No Matching public key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
                }
            } else {
                throw new XWSSecurityException("Unsupported child element of X509Data encountered");
            }
            return cert.getPublicKey();
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static Key resolveEncryptedKey(EncryptedKey encryptedKey, CallbackHandler callbackHandler) throws XWSSecurityException {
        KeyInfo keyInfo = encryptedKey.getKeyInfo();
        KeyInfoHeaderBlock keyInfoHb = new KeyInfoHeaderBlock(keyInfo);
        Key kek = null;
        try {
            if (keyInfoHb.containsSecurityTokenReference()) {
                kek = AssertionUtil.processSecurityTokenReference(keyInfoHb, callbackHandler);
            } else if (keyInfoHb.containsKeyValue()) {
                DefaultSecurityEnvironmentImpl secEnv = new DefaultSecurityEnvironmentImpl(callbackHandler);
                KeyValue keyValue = keyInfoHb.getKeyValue(0);
                keyValue.getElement().normalize();
                kek = secEnv.getPrivateKey(null, keyValue.getPublicKey(), false);
            } else if (keyInfoHb.containsX509Data()) {
                kek = AssertionUtil.processX509Data(keyInfoHb, callbackHandler);
            } else {
                throw new XWSSecurityException("Unsupported Key Information");
            }
            String algorithmURI = encryptedKey.getEncryptionMethod().getAlgorithm();
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(4, null);
            xmlCipher.setKEK(kek);
            return xmlCipher.decryptKey(encryptedKey, algorithmURI);
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    private static Key processSecurityTokenReference(KeyInfoHeaderBlock keyInfo, CallbackHandler callbackHandler) throws XWSSecurityException {
        PrivateKey returnKey = null;
        DefaultSecurityEnvironmentImpl secEnv = new DefaultSecurityEnvironmentImpl(callbackHandler);
        SecurityTokenReference str = keyInfo.getSecurityTokenReference(0);
        ReferenceElement refElement = str.getReference();
        if (refElement instanceof KeyIdentifier) {
            KeyIdentifier keyId = (KeyIdentifier)refElement;
            byte[] decodedValue = keyId.getDecodedReferenceValue().getBytes();
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                returnKey = secEnv.getPrivateKey(null, decodedValue);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(keyId.getValueType())) {
                throw new XWSSecurityException("Unsupported KeyValueType :" + keyId.getValueType());
            }
        } else if (refElement instanceof X509IssuerSerial) {
            BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
            String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
            returnKey = secEnv.getPrivateKey(null, serialNumber, issuerName);
        } else {
            log.log(Level.SEVERE, "WSS0338.unsupported.reference.mechanism");
            throw new XWSSecurityException("Key reference mechanism not supported");
        }
        return returnKey;
    }

    private static Key processX509Data(KeyInfoHeaderBlock keyInfo, CallbackHandler callbackHandler) throws XWSSecurityException {
        DefaultSecurityEnvironmentImpl secEnv = new DefaultSecurityEnvironmentImpl(callbackHandler);
        X509Data x509Data = keyInfo.getX509Data(0);
        X509Certificate cert = null;
        try {
            if (!x509Data.containsCertificate()) {
                if (x509Data.containsSKI()) {
                    return secEnv.getPrivateKey(null, x509Data.itemSKI(0).getSKIBytes());
                }
                if (x509Data.containsIssuerSerial()) {
                    return secEnv.getPrivateKey(null, x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                }
                log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                throw new XWSSecurityException("Unsupported child element of X509Data encountered");
            }
            cert = x509Data.itemCertificate(0).getX509Certificate();
            return secEnv.getPrivateKey(null, cert);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0602.illegal.x509.data", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static com.sun.xml.wss.saml.Assertion fromElement(Element element) throws SAMLException {
        try {
            if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb") != null) {
                JAXBContext jc = SAMLJAXBUtil.getJAXBContext();
                Unmarshaller u = jc.createUnmarshaller();
                return new Assertion((AssertionImpl)u.unmarshal((Node)element));
            }
            if (element.getAttributeNode("ID") != null) {
                JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
                Unmarshaller u = jc.createUnmarshaller();
                Object el = u.unmarshal((Node)element);
                return new com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion((com.sun.xml.wss.saml.internal.saml20.jaxb20.AssertionType)((JAXBElement)el).getValue());
            }
            JAXBContext jc = SAMLJAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            Object el = u.unmarshal((Node)element);
            return new com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion((AssertionType)((JAXBElement)el).getValue());
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    public static String getConfirmationMethod(Element assertion) {
        NodeList nl = null;
        nl = assertion.getAttributeNode("ID") != null ? assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation") : assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
        if (nl.getLength() == 0) {
            return null;
        }
        Element confirmationMethod = (Element)nl.item(0);
        try {
            if (assertion.getAttributeNode("ID") != null) {
                return confirmationMethod.getAttribute("Method");
            }
            return confirmationMethod.getTextContent();
        }
        catch (DOMException ex) {
            return null;
        }
    }

    private static NodeList skipAdviceValidation(Element assertion, NodeList nodeList) {
        boolean keyPresent = false;
        int returnNodeIndex = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getParentNode().getParentNode().getParentNode().getParentNode().getLocalName().equals("Advice")) continue;
            keyPresent = true;
            returnNodeIndex = i;
            break;
        }
        if (keyPresent) {
            return ((Element)nodeList.item(returnNodeIndex)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        }
        return null;
    }

    public static Element getSubjectConfirmationKeyInfo(Element assertion) throws XWSSecurityException {
        try {
            Element keyInfo;
            NodeList nl = null;
            NodeList nl1 = null;
            nl1 = assertion.getAttributeNode("ID") != null ? assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData") : assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            if (nl1.getLength() == 0) {
                throw new XWSSecurityException("SAML Assertion does not contain a key");
            }
            nl = AssertionUtil.skipAdviceValidation(assertion, nl1);
            if (nl == null || nl.getLength() == 0) {
                throw new XWSSecurityException("SAML Assertion does not contain a key");
            }
            if (nl.getLength() != 0 && (keyInfo = (Element)nl.item(0)) != null) {
                return keyInfo;
            }
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
        throw new XWSSecurityException("Unable to locate KeyInfo inside SubjectConfirmation of SAML Assertion");
    }
}

