/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class SamlTokenBuilder
extends TokenBuilder {
    private AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
    private boolean forSign = false;
    private String id;
    private MutableXMLStreamBuffer buffer;
    private XMLStreamReader reader;

    public SamlTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, boolean forSign) {
        super(context);
        this.forSign = forSign;
        this.keyBinding = samlBinding;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        Key dataProtectionKey;
        String asID;
        BuilderResult result = new BuilderResult();
        SecurityHeaderElement she = null;
        Element samlAssertion = this.keyBinding.getAssertion();
        if (samlAssertion == null) {
            this.reader = this.keyBinding.getAssertionReader();
            if (this.reader != null) {
                try {
                    StreamWriterBufferCreator bCreator;
                    this.reader.next();
                    this.id = this.reader.getAttributeValue(null, "AssertionID");
                    if (this.id == null) {
                        this.id = this.reader.getAttributeValue(null, "ID");
                    }
                    this.buffer = new MutableXMLStreamBuffer();
                    StreamWriterBufferCreator writer_tmp = bCreator = new StreamWriterBufferCreator(this.buffer);
                    while (8 != this.reader.getEventType()) {
                        StreamUtil.writeCurrentEvent(this.reader, (XMLStreamWriter)writer_tmp);
                        this.reader.next();
                    }
                }
                catch (XMLStreamException ex) {
                    throw new XWSSecurityException((Throwable)ex);
                }
            }
        }
        if (samlAssertion != null) {
            she = new GSHeaderElement(samlAssertion);
        } else if (this.reader != null) {
            she = new GSHeaderElement((XMLStreamBuffer)this.buffer);
            she.setId(this.id);
        }
        String idVal = "";
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        Key samlkey = null;
        if (samlAssertion != null) {
            asID = samlAssertion.getAttributeNS(null, "AssertionID");
            if (she == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1811_NULL_SAML_ASSERTION());
                throw new XWSSecurityException("SAML Assertion is NULL");
            }
            if (asID == null || asID.length() == 0) {
                idVal = samlAssertion.getAttributeNS(null, "ID");
                she.setId(idVal);
            } else {
                she.setId(asID);
            }
        } else {
            if (she == null) {
                she = (SecurityHeaderElement)this.context.getExtraneousProperty("incoming_saml_assertion");
            }
            if (she == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1811_NULL_SAML_ASSERTION());
                throw new XWSSecurityException("SAML Assertion is NULL");
            }
            idVal = asID = she.getId();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "SAML Assertion id:{0}", asID);
        }
        if (this.forSign) {
            PrivateKeyBinding privKBinding = (PrivateKeyBinding)this.keyBinding.getKeyBinding();
            dataProtectionKey = privKBinding.getPrivateKey();
            if (dataProtectionKey == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1810_NULL_PRIVATEKEY_SAML());
                throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for SAML Policy ");
            }
            if (this.context.getSecurityHeader().getChildElement(she.getId()) == null) {
                this.context.getSecurityHeader().add(she);
            }
        } else {
            SecurityHeaderElement assertion = (SecurityHeaderElement)this.context.getExtraneousProperty("incoming_saml_assertion");
            samlkey = ((SAMLAssertion)assertion).getKey();
            if (!"".equals(this.keyBinding.getKeyAlgorithm())) {
                keyEncAlgo = this.keyBinding.getKeyAlgorithm();
            }
            String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(this.context);
            dataProtectionKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
        }
        Element authorityBinding = this.keyBinding.getAuthorityBinding();
        String referenceType = this.keyBinding.getReferenceType();
        if (referenceType.equals("Embedded")) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1813_UNSUPPORTED_EMBEDDEDREFERENCETYPE_SAML());
            throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
        }
        String assertionId = she.getId();
        if (authorityBinding == null) {
            KeyIdentifier keyIdentifier = new KeyIdentifier(this.context.getSOAPVersion());
            keyIdentifier.setValue(assertionId);
            if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(she.getNamespaceURI())) {
                keyIdentifier.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
            } else {
                keyIdentifier.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            }
            SecurityTokenReference samlSTR = this.elementFactory.createSecurityTokenReference(keyIdentifier);
            if (idVal != null) {
                samlSTR.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            } else {
                samlSTR.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
            ((NamespaceContextEx)this.context.getNamespaceContext()).addWSS11NS();
            this.buildKeyInfo(samlSTR);
        }
        if (!this.forSign) {
            HashMap ekCache = this.context.getEncryptedKeyCache();
            JAXBEncryptedKey ek = (JAXBEncryptedKey)this.elementFactory.createEncryptedKey(this.context.generateID(), keyEncAlgo, this.keyInfo, samlkey, dataProtectionKey);
            this.context.getSecurityHeader().add(ek);
            String ekId = ek.getId();
            DirectReference dr = this.buildDirectReference(ekId, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            result.setKeyInfo(this.buildKeyInfo(dr, ""));
        } else {
            result.setKeyInfo(this.keyInfo);
        }
        HashMap<String, PrivateKey> sentSamlKeys = (HashMap<String, PrivateKey>)this.context.getExtraneousProperty("stored_saml_keys");
        if (sentSamlKeys == null) {
            sentSamlKeys = new HashMap<String, PrivateKey>();
        }
        sentSamlKeys.put(assertionId, (PrivateKey)dataProtectionKey);
        this.context.setExtraneousProperty("stored_saml_keys", sentSamlKeys);
        result.setDataProtectionKey(dataProtectionKey);
        return result;
    }
}

