/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.security.Key;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EncryptedKeyToken
extends SecurityHeaderBlockImpl
implements SecurityToken,
Token {
    EncryptedKey encryptedKey = null;
    SOAPElement elem = null;

    public EncryptedKeyToken(SOAPElement elem) {
        this.elem = elem;
    }

    public Key getSecretKey(Key privKey, String dataEncAlgo) throws XWSSecurityException {
        try {
            XMLCipher xmlc = null;
            String algorithm = null;
            if (this.elem != null) {
                NodeList nl = this.elem.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
                if (nl != null) {
                    algorithm = ((Element)nl.item(0)).getAttribute("Algorithm");
                }
                xmlc = XMLCipher.getInstance(algorithm);
                xmlc.init(4, privKey);
                if (this.encryptedKey == null) {
                    this.encryptedKey = xmlc.loadEncryptedKey((Element)this.elem);
                }
            }
            if (xmlc == null) {
                throw new XWSSecurityException("XMLCipher is null while getting SecretKey from EncryptedKey");
            }
            SecretKey symmetricKey = (SecretKey)xmlc.decryptKey(this.encryptedKey, dataEncAlgo);
            return symmetricKey;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new XWSSecurityException("Error while getting SecretKey from EncryptedKey");
        }
    }

    @Override
    public SOAPElement getAsSoapElement() {
        if (this.elem != null) {
            return this.elem;
        }
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getId() {
        try {
            return this.elem.getAttribute("Id");
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while extracting ID");
        }
    }

    public KeyInfoHeaderBlock getKeyInfo() {
        try {
            if (this.encryptedKey != null) {
                return new KeyInfoHeaderBlock(this.encryptedKey.getKeyInfo());
            }
            Iterator iter = this.elem.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
            Element keyInfoElem = null;
            if (iter.hasNext()) {
                keyInfoElem = (Element)iter.next();
            }
            KeyInfo keyInfo = new KeyInfo(keyInfoElem, "MessageConstants.DSIG_NS");
            return new KeyInfoHeaderBlock(keyInfo);
        }
        catch (XWSSecurityException ex) {
            throw new XWSSecurityRuntimeException("Error while extracting KeyInfo", ex);
        }
        catch (XMLSecurityException ex) {
            throw new XWSSecurityRuntimeException("Error while extracting KeyInfo", ex);
        }
    }

    public String getType() {
        return "xenc:EncryptedKey";
    }

    public Object getTokenValue() {
        return this;
    }
}

