/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.SecurityTokenReference;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken13;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.secconv.impl.bindings.SecurityContextTokenType;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.ws.security.secext10.KeyIdentifierType;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityContextTokenImpl;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.SamlKeyIdentifier;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WSSAssertion;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.ReflectionUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.crypto.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.soap.SOAPElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SecurityUtil {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.crypto", "com.sun.xml.wss.logging.impl.crypto.LogStrings");

    public static SecretKey generateSymmetricKey(String algorithm) throws XWSSecurityException {
        try {
            String jceAlgo = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
            KeyGenerator keyGen = KeyGenerator.getInstance(jceAlgo);
            int length = 0;
            length = jceAlgo.startsWith("DES") ? 168 : JCEMapper.getKeyLengthFromURI((String)algorithm);
            keyGen.init(length);
            return keyGen.generateKey();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1208_FAILEDTO_GENERATE_RANDOM_SYMMETRICKEY(e.getMessage()), new Object[]{e.getMessage()});
            throw new XWSSecurityException("Unable to Generate Symmetric Key", (Throwable)e);
        }
    }

    public static int getLengthFromAlgorithm(String algorithm) throws XWSSecurityException {
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return 32;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return 16;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 24;
        }
        throw new UnsupportedOperationException("TODO: not yet implemented keyLength for" + algorithm);
    }

    public static String generateUUID() {
        Random rnd = new Random();
        int intRandom = rnd.nextInt();
        String id = "XWSSGID-" + String.valueOf(System.currentTimeMillis()) + String.valueOf(intRandom);
        return id;
    }

    public static byte[] P_SHA1(byte[] secret, byte[] seed) throws Exception {
        byte[] aBytes = seed;
        Mac hMac = Mac.getInstance("HMACSHA1");
        SecretKeySpec sKey = new SecretKeySpec(secret, "HMACSHA1");
        hMac.init(sKey);
        hMac.update(aBytes);
        aBytes = hMac.doFinal();
        hMac.reset();
        hMac.init(sKey);
        hMac.update(aBytes);
        hMac.update(seed);
        byte[] result = hMac.doFinal();
        return result;
    }

    public static byte[] P_SHA1(byte[] secret, byte[] seed, int requiredSize) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hMac = Mac.getInstance("HMACSHA1");
        SecretKeySpec sKey = new SecretKeySpec(secret, "HMACSHA1");
        byte[] result = new byte[requiredSize];
        int copied = 0;
        byte[] aBytes = seed;
        hMac.init(sKey);
        hMac.update(aBytes);
        aBytes = hMac.doFinal();
        int rounds = requiredSize / aBytes.length;
        if (requiredSize % aBytes.length != 0) {
            ++rounds;
        }
        for (int i = 0; i < rounds; ++i) {
            hMac.reset();
            hMac.init(sKey);
            hMac.update(aBytes);
            hMac.update(seed);
            byte[] generated = hMac.doFinal();
            int takeBytes = i != rounds - 1 ? generated.length : requiredSize - generated.length * i;
            System.arraycopy(generated, 0, result, copied, takeBytes);
            copied += takeBytes;
            hMac.init(sKey);
            hMac.update(aBytes);
            aBytes = hMac.doFinal();
        }
        return result;
    }

    public static String getSecretKeyAlgorithm(String encryptionAlgo) {
        String encAlgo = JCEMapper.translateURItoJCEID((String)encryptionAlgo);
        if (encAlgo.startsWith("AES")) {
            return "AES";
        }
        if (encAlgo.startsWith("DESede")) {
            return "DESede";
        }
        if (encAlgo.startsWith("DES")) {
            return "DES";
        }
        return encAlgo;
    }

    public static void checkIncludeTokenPolicyOpt(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.UsernameTokenBinding untBinding, String unTokenid) throws XWSSecurityException {
        try {
            if (!untBinding.policyTokenWasSet()) {
                return;
            }
            String itVersion = untBinding.getIncludeToken();
            if (!AuthenticationTokenPolicy.UsernameTokenBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itVersion)) {
                if (AuthenticationTokenPolicy.UsernameTokenBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itVersion)) {
                } else {
                    throw new UnsupportedOperationException(untBinding.getIncludeToken() + " not supported yet as IncludeToken policy");
                }
            }
            untBinding.setReferenceType("Direct");
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkIncludeTokenPolicy(FilterProcessingContext context, AuthenticationTokenPolicy.X509CertificateBinding certInfo, String x509id) throws XWSSecurityException {
        HashMap insertedX509Cache = context.getInsertedX509Cache();
        X509SecurityToken x509Token = (X509SecurityToken)insertedX509Cache.get(x509id);
        try {
            String itVersion;
            block11: {
                block10: {
                    if (x509Token != null) return;
                    if (!certInfo.policyTokenWasSet()) {
                        return;
                    }
                    itVersion = certInfo.getIncludeToken();
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itVersion)) break block10;
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS.equals(itVersion)) break block10;
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itVersion)) break block10;
                    if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_VER2.equals(itVersion)) break block11;
                }
                SecurityUtil.insertCertificate(context, certInfo, x509id);
                return;
            }
            if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER.equals(itVersion)) {
                if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER_VER2.equals(itVersion)) {
                    if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ONCE.equals(certInfo.getIncludeToken())) return;
                    throw new UnsupportedOperationException(AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ONCE + " not supported yet as IncludeToken policy");
                }
            }
            WSSAssertion wssAssertion = context.getWSSAssertion();
            if (!"Direct".equals(certInfo.getReferenceType())) return;
            if (wssAssertion == null) {
                certInfo.setReferenceType("Identifier");
                return;
            }
            if (wssAssertion.getRequiredProperties().contains("MustSupportRefKeyIdentifier")) {
                certInfo.setReferenceType("Identifier");
                return;
            }
            if (!wssAssertion.getRequiredProperties().contains("MustSupportRefThumbprint")) return;
            certInfo.setReferenceType("Thumbprint");
            return;
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkIncludeTokenPolicyOpt(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.X509CertificateBinding certInfo, String x509id) throws XWSSecurityException {
        try {
            String itVersion;
            block12: {
                block11: {
                    if (!certInfo.policyTokenWasSet()) {
                        return;
                    }
                    itVersion = certInfo.getIncludeToken();
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itVersion)) break block11;
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS.equals(itVersion)) break block11;
                    if (AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itVersion)) break block11;
                    if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ALWAYS_VER2.equals(itVersion)) break block12;
                }
                certInfo.setReferenceType("Direct");
                return;
            }
            if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER.equals(itVersion)) {
                if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_NEVER_VER2.equals(itVersion)) {
                    if (!AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ONCE.equals(certInfo.getIncludeToken())) return;
                    throw new UnsupportedOperationException(AuthenticationTokenPolicy.X509CertificateBinding.INCLUDE_ONCE + " not supported yet as IncludeToken policy");
                }
            }
            WSSAssertion wssAssertion = context.getWSSAssertion();
            if (!"Direct".equals(certInfo.getReferenceType())) return;
            if (wssAssertion == null) {
                certInfo.setReferenceType("IssuerSerialNumber");
                return;
            }
            if (wssAssertion.getRequiredProperties().contains("MustSupportRefIssuerSerial")) {
                certInfo.setReferenceType("IssuerSerialNumber");
                return;
            }
            if (wssAssertion.getRequiredProperties().contains("MustSupportRefThumbprint")) {
                certInfo.setReferenceType("Thumbprint");
                return;
            }
            if (!wssAssertion.getRequiredProperties().contains("MustSupportRefKeyIdentifier")) return;
            certInfo.setReferenceType("Identifier");
            return;
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static String getWsuIdOrId(Element elem) throws XWSSecurityException {
        NamedNodeMap nmap = elem.getAttributes();
        Node attr = nmap.getNamedItem("Id");
        if (attr == null) {
            attr = nmap.getNamedItem("AssertionID");
            if (attr == null) {
                attr = nmap.getNamedItem("ID");
            }
            if (attr == null) {
                throw new XWSSecurityException("Issued Token Element does not have a Id or AssertionId attribute");
            }
        }
        return attr.getNodeValue();
    }

    public static void resolveSCT(FilterProcessingContext context, SecureConversationTokenKeyBinding sctBinding) throws XWSSecurityException {
        String sctId;
        String sctPolicyId = sctBinding.getUUID();
        IssuedTokenContext ictx = null;
        String protocol = context.getWSSCVersion(context.getSecurityPolicyVersion());
        if (context.isClient()) {
            sctId = context.getSCPolicyIDtoSctIdMap(sctPolicyId);
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(protocol, sctId, !context.isExpired(), !context.isInboundMessage());
            ictx = IssuedTokenManager.getInstance().createIssuedTokenContext((IssuedTokenConfiguration)config, null);
            try {
                IssuedTokenManager.getInstance().getIssuedToken(ictx);
            }
            catch (WSTrustException e) {
                throw new XWSSecurityException((Throwable)e);
            }
        }
        if (ictx == null) {
            sctId = "";
            if (context instanceof JAXBFilterProcessingContext) {
                com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken sct;
                Object sctObject = context.getExtraneousProperty("Incoming_SCT");
                if (sctObject == null) {
                    throw new XWSSecurityException("SecureConversation Session Context not Found");
                }
                if (sctObject instanceof com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken) {
                    sct = (com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken)sctObject;
                    sctId = sct.getSCId();
                } else if (sctObject instanceof com.sun.xml.ws.security.SecurityContextToken) {
                    sct = (com.sun.xml.ws.security.SecurityContextToken)sctObject;
                    sctId = sct.getIdentifier().toString();
                }
            } else {
                com.sun.xml.ws.security.SecurityContextToken sct = (com.sun.xml.ws.security.SecurityContextToken)context.getExtraneousProperty("Incoming_SCT");
                if (sct == null) {
                    throw new XWSSecurityException("SecureConversation Session Context not Found");
                }
                sctId = sct.getIdentifier().toString();
            }
            ictx = ((SessionManager)context.getExtraneousProperty("SessionManager")).getSecurityContext(sctId, !context.isExpired());
            URI identifier = null;
            String instance = null;
            String wsuId = null;
            com.sun.xml.ws.security.SecurityContextToken sct = (com.sun.xml.ws.security.SecurityContextToken)ictx.getSecurityToken();
            if (sct != null) {
                identifier = sct.getIdentifier();
                instance = sct.getInstance();
                wsuId = sct.getWsuId();
            } else {
                SecurityContextTokenInfo sctInfo = ictx.getSecurityContextTokenInfo();
                identifier = URI.create(sctInfo.getIdentifier());
                instance = sctInfo.getInstance();
                wsuId = sctInfo.getExternalId();
            }
            ictx.setSecurityToken((Token)WSTrustElementFactory.newInstance((String)protocol).createSecurityContextToken(identifier, instance, wsuId));
        }
        if (ictx == null) {
            throw new XWSSecurityException("SecureConversation Session Context not Found");
        }
        context.setSecureConversationContext(ictx);
    }

    public static void resolveIssuedToken(FilterProcessingContext context, IssuedTokenKeyBinding itkb) throws XWSSecurityException {
        String itPolicyId = itkb.getUUID();
        IssuedTokenContext ictx = context.getIssuedTokenContext(itPolicyId);
        boolean clientSide = true;
        if (ictx == null) {
            ictx = context.getTrustCredentialHolder();
            clientSide = false;
        }
        if (ictx == null) {
            throw new XWSSecurityException("Trust IssuedToken not Found");
        }
        if (ictx.getSecurityToken() instanceof GenericToken) {
            itkb.setRealId(((GenericToken)ictx.getSecurityToken()).getId());
        }
        context.setTrustContext(ictx);
        if (ictx.getProofKey() == null && clientSide) {
            X509Certificate cert = context.getSecurityEnvironment().getDefaultCertificate(context.getExtraneousProperties());
            ictx.setRequestorCertificate(cert);
        }
    }

    public static void initInferredIssuedTokenContext(FilterProcessingContext wssContext, Token str, Key returnKey) throws XWSSecurityException {
        IssuedTokenContextImpl ictx = (IssuedTokenContextImpl)wssContext.getTrustCredentialHolder();
        if (ictx == null) {
            ictx = new IssuedTokenContextImpl();
        }
        ictx.setProofKey(returnKey.getEncoded());
        ictx.setUnAttachedSecurityTokenReference(str);
        wssContext.setTrustCredentialHolder((IssuedTokenContext)ictx);
    }

    public static boolean isEncryptedKey(SOAPElement elem) {
        return "EncryptedKey".equals(elem.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(elem.getNamespaceURI());
    }

    public static boolean isBinarySecret(SOAPElement elem) {
        return "BinarySecret".equals(elem.getLocalName()) && "http://schemas.xmlsoap.org/ws/2005/02/trust".equals(elem.getNamespaceURI());
    }

    public static SecurityContextTokenImpl locateBySCTId(FilterProcessingContext context, String sctId) throws XWSSecurityException {
        Hashtable contextMap = context.getIssuedTokenContextMap();
        if (contextMap == null) {
            return null;
        }
        for (Map.Entry entry : contextMap.entrySet()) {
            com.sun.xml.ws.security.SecurityContextToken ret;
            Token securityToken;
            String tokenId = (String)entry.getKey();
            Object token = entry.getValue();
            if (!(token instanceof IssuedTokenContext) || !((securityToken = ((IssuedTokenContext)token).getSecurityToken()) instanceof com.sun.xml.ws.security.SecurityContextToken) || !sctId.equals((ret = (com.sun.xml.ws.security.SecurityContextToken)securityToken).getIdentifier().toString())) continue;
            return new SecurityContextTokenImpl((Document)context.getSOAPMessage().getSOAPPart(), ret.getIdentifier().toString(), ret.getInstance(), ret.getWsuId(), ret.getExtElements());
        }
        return null;
    }

    public static void updateSamlVsKeyCache(SecurityTokenReference str, FilterProcessingContext ctx, Key symKey) {
        ReferenceElement ref = ((com.sun.xml.wss.core.SecurityTokenReference)str).getReference();
        if (ref instanceof com.sun.xml.wss.core.reference.KeyIdentifier) {
            String assertionId = ((com.sun.xml.wss.core.reference.KeyIdentifier)ref).getReferenceValue();
            if (ctx.getSamlIdVSKeyCache().get(assertionId) == null) {
                ctx.getSamlIdVSKeyCache().put(assertionId, symKey);
            }
        }
    }

    public static void updateSamlVsKeyCache(SecurityTokenReferenceType str, FilterProcessingContext ctx, Key symKey) {
        List list = str.getAny();
        for (int i = 0; i < list.size(); ++i) {
            HashMap sentSamlKeys;
            Object item = list.get(i);
            if (item instanceof JAXBElement) {
                item = ((JAXBElement)item).getValue();
            }
            if (!(item instanceof KeyIdentifierType)) continue;
            String assertionId = ((KeyIdentifierType)item).getValue();
            if (ctx.getSamlIdVSKeyCache().get(assertionId) == null) {
                ctx.getSamlIdVSKeyCache().put(assertionId, symKey);
            }
            if ((sentSamlKeys = (HashMap)ctx.getExtraneousProperty("stored_saml_keys")) == null || sentSamlKeys.get(assertionId) != null) continue;
            sentSamlKeys.put(assertionId, symKey);
        }
    }

    public static void insertCertificate(FilterProcessingContext context, AuthenticationTokenPolicy.X509CertificateBinding certInfo, String x509id) throws XWSSecurityException {
        HashMap insertedX509Cache = context.getInsertedX509Cache();
        try {
            String valueType = certInfo.getValueType();
            if (valueType == null || valueType.equals("")) {
                valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            }
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            X509SecurityToken x509Token = new X509SecurityToken((Document)secureMessage.getSOAPPart(), certInfo.getX509Certificate(), x509id, valueType);
            secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(x509Token);
            insertedX509Cache.put(x509id, x509Token);
            certInfo.setReferenceType("Direct");
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static String getDataEncryptionAlgo(JAXBFilterProcessingContext context) {
        WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
        String tmp = "";
        if (PolicyTypeUtil.encryptionPolicy(policy)) {
            EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
            MLSPolicy keyBinding = ((EncryptionPolicy)policy).getKeyBinding();
            tmp = featureBinding.getDataEncryptionAlgorithm();
            if (PolicyTypeUtil.issuedTokenKeyBinding(keyBinding) && context.getTrustContext() != null) {
                tmp = context.getTrustContext().getEncryptWith();
            }
        }
        if ((tmp == null || "".equals(tmp)) && context.getAlgorithmSuite() != null) {
            tmp = context.getAlgorithmSuite().getEncryptionAlgorithm();
        }
        return tmp;
    }

    public static URL loadFromContext(String configFileName, Object context) {
        return ReflectionUtil.invoke(context, "getResource", URL.class, configFileName);
    }

    public static URL loadFromClasspath(String configFileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(configFileName);
        }
        return cl.getResource(configFileName);
    }

    public static Element convertSTRToElement(Object strElem, Document doc) throws XWSSecurityException {
        if (strElem == null || strElem instanceof Element) {
            return (Element)strElem;
        }
        com.sun.xml.wss.core.SecurityTokenReference stRef = null;
        if (strElem instanceof KeyIdentifier) {
            KeyIdentifier keyIdStrElem = (KeyIdentifier)strElem;
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyIdStrElem.getValueType())) {
                stRef = new com.sun.xml.wss.core.SecurityTokenReference(doc);
                SamlKeyIdentifier keyId = new SamlKeyIdentifier(doc);
                keyId.setReferenceValue(keyIdStrElem.getReferenceValue());
                keyId.setValueType(keyIdStrElem.getValueType());
                stRef.setReference(keyId);
            } else {
                throw new XWSSecurityException("Unsupported reference type encountered");
            }
        }
        return stRef;
    }

    public static void copySubject(final Subject to, final Subject from) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                to.getPrincipals().addAll(from.getPrincipals());
                to.getPublicCredentials().addAll(from.getPublicCredentials());
                to.getPrivateCredentials().addAll(from.getPrivateCredentials());
                return null;
            }
        });
    }

    public static Subject getSubject(final Map context) {
        Subject otherPartySubject = (Subject)context.get("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject otherPartySubj = new Subject();
                context.put("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    public static com.sun.xml.ws.security.SecurityContextToken getSCT(com.sun.xml.ws.security.SecurityContextToken sct, SOAPVersion version) {
        if (sct instanceof com.sun.xml.ws.security.secconv.impl.wssx.bindings.SecurityContextTokenType) {
            return new SecurityContextToken13((com.sun.xml.ws.security.secconv.impl.wssx.bindings.SecurityContextTokenType)sct, version);
        }
        return new SecurityContextToken((SecurityContextTokenType)sct, version);
    }

    public static void copy(Map p1, Map p2) {
        if (p2 == null || p1 == null) {
            return;
        }
        p1.putAll(p2);
    }

    public static Object newInstance(String className, ClassLoader classLoader, String spiName) {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new XWSSecurityRuntimeException("The " + spiName + " :" + className + " specified in META-INF/services was not found", x);
        }
        catch (Exception x) {
            throw new XWSSecurityRuntimeException("The " + spiName + " :" + className + " specified in META-INF/services could not be instantiated", x);
        }
    }

    public static Object loadSPIClass(URL url, String spiName) {
        block6: {
            InputStream is = null;
            if (url == null) {
                return null;
            }
            try {
                is = url.openStream();
                if (is == null) break block6;
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        Object obj = SecurityUtil.newInstance(factoryClassName, Thread.currentThread().getContextClassLoader(), spiName);
                        return obj;
                    }
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static long toLong(String lng) throws XWSSecurityException {
        if (lng == null) {
            return 0L;
        }
        Long ret = 0L;
        try {
            ret = Long.valueOf(lng);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0719_ERROR_GETTING_LONG_VALUE());
            throw new XWSSecurityException((Throwable)e);
        }
        return ret;
    }

    public static String getKeyAlgo(String algo) {
        if (algo != null && algo.equals("SHA256withRSA")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
        if (algo != null && algo.equals("SHA384withRSA")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
        if (algo != null && algo.equals("SHA512withRSA")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }
}

