/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.ApplicationCanonicalizer;
import com.sun.xml.wss.impl.c14n.Canonicalizer;
import com.sun.xml.wss.impl.c14n.ImageCanonicalizer;
import com.sun.xml.wss.impl.c14n.MimeHeaderCanonicalizer;
import com.sun.xml.wss.impl.c14n.TextPlainCanonicalizer;
import jakarta.mail.internet.ContentType;
import java.nio.charset.Charset;
import java.util.HashMap;

public class CanonicalizerFactory {
    static MimeHeaderCanonicalizer _mhCanonicalizer = null;
    static HashMap<String, Object> _canonicalizers = new HashMap(10);

    public static final Canonicalizer getCanonicalizer(String mimeType) throws Exception {
        String charset;
        String primaryMimeType;
        Canonicalizer _canonicalizer;
        ContentType contentType = new ContentType(mimeType);
        String baseMimeType = contentType.getBaseType();
        if (baseMimeType.equalsIgnoreCase("text/plain")) {
            CanonicalizerFactory.ensureRegisteredCharset(contentType);
        }
        if ((_canonicalizer = (Canonicalizer)_canonicalizers.get(primaryMimeType = contentType.getPrimaryType())) == null) {
            _canonicalizer = CanonicalizerFactory.newCanonicalizer(primaryMimeType);
        }
        if ((charset = contentType.getParameter("charset")) != null) {
            _canonicalizer.setCharset(charset);
        }
        return _canonicalizer;
    }

    public static final Canonicalizer newCanonicalizer(String primaryMimeType) {
        Canonicalizer canonicalizer = null;
        if (primaryMimeType.equalsIgnoreCase("text")) {
            canonicalizer = new TextPlainCanonicalizer();
        } else if (primaryMimeType.equalsIgnoreCase("image")) {
            canonicalizer = new ImageCanonicalizer();
        } else if (primaryMimeType.equalsIgnoreCase("application")) {
            canonicalizer = new ApplicationCanonicalizer();
        }
        _canonicalizers.put(primaryMimeType, canonicalizer);
        return canonicalizer;
    }

    public static final MimeHeaderCanonicalizer getMimeHeaderCanonicalizer(String charset) {
        if (_mhCanonicalizer == null) {
            _mhCanonicalizer = new MimeHeaderCanonicalizer();
        }
        _mhCanonicalizer.setCharset(charset);
        return _mhCanonicalizer;
    }

    public static void registerCanonicalizer(String baseMimeType, Canonicalizer implementingClass) {
        _canonicalizers.put(baseMimeType, implementingClass);
    }

    public static void registerCanonicalizer(String baseMimeType, String implementingClass) throws XWSSecurityException {
        try {
            Class<?> _class = Class.forName(implementingClass);
            Canonicalizer canonicalizer = (Canonicalizer)_class.newInstance();
            _canonicalizers.put(baseMimeType, canonicalizer);
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public static boolean ensureRegisteredCharset(ContentType contentType) {
        String charsetName = contentType.getParameter("charset");
        if (charsetName != null) {
            return Charset.forName(charsetName).isRegistered();
        }
        return true;
    }
}

