/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class SignedElements
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SignedElements,
SecurityAssertionValidator {
    private String xpathVersion;
    private List<String> targetList;
    private boolean populated = false;
    private static QName XPathVersion = new QName("XPathVersion");
    private static List<String> emptyList = Collections.emptyList();
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion;

    public SignedElements() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public SignedElements(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public String getXPathVersion() {
        this.populate();
        return this.xpathVersion;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public void addTarget(String target) {
        if (this.targetList == null) {
            this.targetList = new ArrayList<String>();
        }
        this.targetList.add(target);
    }

    public void removeTarget(String target) {
        if (this.targetList != null) {
            this.targetList.remove(target);
        }
    }

    @Override
    public Iterator<String> getTargets() {
        this.populate();
        if (this.targetList != null) {
            return this.targetList.iterator();
        }
        return emptyList.iterator();
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            this.xpathVersion = this.getAttributeValue(XPathVersion);
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isXPath(assertion, this.spVersion)) {
                        this.addTarget(assertion.getValue());
                        continue;
                    }
                    if (assertion.isOptional()) continue;
                    Constants.log_invalid_assertion(assertion, isServer, "SignedElements");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

