/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.api.tx.at.TransactionalFeature;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import javax.transaction.Transaction;

public class WSATTubeHelper {
    public static boolean isSSLRequired() {
        return false;
    }

    public static TransactionalAttribute getTransactionalAttribute(TransactionalFeature feature, Packet packet, WSDLPort port) {
        if (feature == null) {
            feature = new TransactionalFeature(true, Transactional.TransactionFlowType.SUPPORTS, Transactional.Version.DEFAULT);
        }
        if (port == null) {
            boolean isRequired;
            boolean isEnabled = feature.isEnabled() && Transactional.TransactionFlowType.NEVER != feature.getFlowType();
            boolean bl = isRequired = Transactional.TransactionFlowType.MANDATORY == feature.getFlowType();
            if (WSATHelper.isDebugEnabled()) {
                WSATTubeHelper.debug("no wsdl port found, the effective transaction attribute is: enabled(" + isEnabled + "),required(" + isRequired + "), version(" + feature.getVersion() + ").");
            }
            return new TransactionalAttribute(isEnabled, isRequired, feature.getVersion());
        }
        WSDLBoundOperation wsdlBoundOperation = packet.getMessage().getOperation(port);
        if (wsdlBoundOperation != null && wsdlBoundOperation.getOperation() != null && !wsdlBoundOperation.getOperation().isOneWay()) {
            boolean isRequired;
            String opName = wsdlBoundOperation.getName().getLocalPart();
            boolean isEnabled = feature.isEnabled(opName) && Transactional.TransactionFlowType.NEVER != feature.getFlowType(opName);
            boolean bl = isRequired = Transactional.TransactionFlowType.MANDATORY == feature.getFlowType(opName);
            if (WSATHelper.isDebugEnabled()) {
                WSATTubeHelper.debug("the effective transaction attribute for operation' " + opName + "' is : enabled(" + isEnabled + "),required(" + isRequired + "), version(" + feature.getVersion() + ").");
            }
            return new TransactionalAttribute(isEnabled, isRequired, feature.getVersion());
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATTubeHelper.debug("no twoway operation found for this request, the effective transaction attribute is disabled.");
        }
        return new TransactionalAttribute(false, false, Transactional.Version.DEFAULT);
    }

    static String getWSATTxIdForTransaction(Transaction transaction) {
        return "tmpwsattxid";
    }

    private static void debug(String message) {
        WSATHelper.getInstance().debug("WSATTubeHelper:" + message);
    }
}

