/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.Property;
import org.glassfish.enterprise.iiop.api.GlassFishORBLifeCycleListener;
import org.glassfish.enterprise.iiop.impl.ASORBUtilities;
import org.glassfish.enterprise.iiop.impl.IIOPUtils;
import org.glassfish.enterprise.iiop.impl.PEORBConfigurator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class GlassFishORBManager {
    static Logger logger = LogDomains.getLogger(GlassFishORBManager.class, (String)"javax.enterprise.system.util");
    private static IIOPUtils iiopUtils = IIOPUtils.getInstance();
    private static final boolean debug = true;
    private static final String ORB_CLASS = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_CLASS = "com.sun.corba.se.impl.orb.ORBImpl";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String PEORB_CONFIG_CLASS = "org.glassfish.enterprise.iiop.impl.PEORBConfigurator";
    private static final String IIOP_SSL_SOCKET_FACTORY_CLASS = "com.sun.enterprise.iiop.IIOPSSLSocketFactory";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private static final String PI_ORB_INITIALIZER_CLASS_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String SUN_USER_CONFIGURATOR_PREFIX = "com.sun.corba.ee.ORBUserConfigurators.";
    public static final String SUN_ORB_ID_PROPERTY = "org.omg.CORBA.ORBId";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.corba.ee.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.corba.ee.ORBServerPort";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBSocketFactoryClass";
    public static final String SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBIORToSocketInfoClass";
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.corba.ee.connection.ORBHighWaterMark";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.corba.ee.transport.ORBListenSocket";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static final String SUN_LISTEN_ADDR_ANY_ADDRESS = "com.sun.CORBA.orb.AddrAnyAddress";
    private static final String ORB_IOR_ADDR_ANY_INITIALIZER = "com.sun.enterprise.iiop.IORAddrAnyInitializer";
    private static final String DEFAULT_SERVER_ID = "100";
    private static final String DEFAULT_MAX_CONNECTIONS = "1024";
    private static final String J2EE_INITIALIZER = "com.sun.enterprise.iiop.GlassFishORBInitializer";
    private static final String SUN_GIOP_DEFAULT_FRAGMENT_SIZE = "1024";
    private static final String SUN_GIOP_DEFAULT_BUFFER_SIZE = "1024";
    private static final String IIOP_CLEAR_TEXT_CONNECTION = "IIOP_CLEAR_TEXT";
    public static final String DEFAULT_ORB_INIT_HOST = "localhost";
    public static final String DEFAULT_ORB_INIT_PORT = "3700";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String ORB_SSL_CERTDB_PATH = "com.sun.CSIV2.ssl.CertDB";
    private static final String ORB_SSL_CERTDB_PASSWORD = "com.sun.CSIV2.ssl.CertDBPassword";
    public static final String SUN_GIOP_FRAGMENT_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBFragmentSize";
    public static final String SUN_GIOP_BUFFER_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBBufferSize";
    public static final String ORB_SSL_CLIENT_REQUIRED = "com.sun.CSIV2.ssl.client.required";
    public static final String ORB_SSL_SERVER_REQUIRED = "com.sun.CSIV2.ssl.server.required";
    public static final String ORB_CLIENT_AUTH_REQUIRED = "com.sun.CSIV2.client.auth.required";
    public static final String S1AS_ORB_ID = "S1AS-ORB";
    private static ORB orb = null;
    private static ReferenceFactoryManager rfm = null;
    private static int orbInitialPort = -1;
    private static IiopListener[] iiopListenerBeans = null;
    private static Orb orbBean = null;
    private static IiopService iiopServiceBean = null;
    private static Properties csiv2Props = new Properties();
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static AtomicBoolean propsInitialized = new AtomicBoolean(false);
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private static final String IIOP_URL = "iiop:1.2@";

    private GlassFishORBManager() {
    }

    public static boolean isEjbAdapterName(String[] adapterName) {
        boolean result = false;
        if (rfm != null) {
            result = rfm.isRfmName(adapterName);
        }
        return result;
    }

    public static boolean isIsACall(String operationName) {
        return operationName.equals("_is_a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ORB getORB(Properties props) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "GlassFishORBManager.getORB->: " + orb);
            }
            GlassFishORBManager.initProperties();
            if (orb == null) {
                GlassFishORBManager.initORB(props);
            }
            ORB oRB = orb;
            return oRB;
        }
        finally {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "GlassFishORBManager.getORB<-: " + orb);
            }
        }
    }

    public static synchronized Properties getCSIv2Props() {
        GlassFishORBManager.initProperties();
        return csiv2Props;
    }

    public static synchronized int getORBInitialPort() {
        GlassFishORBManager.initProperties();
        return orbInitialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initProperties() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "GlassFishORBManager.initProperties->: " + orb);
            }
            if (propsInitialized.get()) return;
            AtomicBoolean atomicBoolean = propsInitialized;
            synchronized (atomicBoolean) {
                if (propsInitialized.get()) return;
                IIOPUtils iiopUtils = IIOPUtils.getInstance();
                iiopServiceBean = iiopUtils.getIiopService();
                try {
                    if (iiopServiceBean == null) {
                        String initialPort = GlassFishORBManager.checkORBInitialPort(EMPTY_PROPERTIES);
                        return;
                    }
                    assert (iiopServiceBean != null);
                    iiopListenerBeans = iiopServiceBean.getIiopListener().toArray(new IiopListener[0]);
                    assert (iiopListenerBeans != null && iiopListenerBeans.length > 0);
                    String initialPort = GlassFishORBManager.checkORBInitialPort(EMPTY_PROPERTIES);
                    orbBean = iiopServiceBean.getOrb();
                    assert (orbBean != null);
                    csiv2Props.put(ORB_CLIENT_AUTH_REQUIRED, String.valueOf(iiopServiceBean.getClientAuthenticationRequired()));
                    boolean corbaSSLRequired = true;
                    for (int i = 0; i < iiopListenerBeans.length; ++i) {
                        if (iiopListenerBeans[i].getSsl() != null) continue;
                        corbaSSLRequired = false;
                        break;
                    }
                    csiv2Props.put(ORB_SSL_SERVER_REQUIRED, String.valueOf(corbaSSLRequired));
                    return;
                }
                catch (NullPointerException npe) {
                    logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
                    return;
                }
                finally {
                    propsInitialized.set(true);
                }
            }
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "GlassFishORBManager.initProperties<-: " + orb);
            }
        }
    }

    public static void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                if (System.getProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, GlassFishORBManager.ORB_SE_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, GlassFishORBManager.ORB_CLASS);
                    }
                }
                if (System.getProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, GlassFishORBManager.ORB_SE_SINGLETON_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, GlassFishORBManager.ORB_SINGLETON_CLASS);
                    }
                }
                System.setProperty(GlassFishORBManager.ORB_UTIL_CLASS_PROPERTY, GlassFishORBManager.RMI_UTIL_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, GlassFishORBManager.RMI_STUB_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, GlassFishORBManager.RMI_PRO_CLASS);
                return null;
            }
        });
    }

    private static void setFOLBProperties(Properties orbInitProperties) {
        orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.oa.rfm.ReferenceManagerConfigurator", "dummy");
        orbInitProperties.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
        orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.folb.ClientGroupManager", "dummy");
        if (ASORBUtilities.isGMSAvailableAndClusterHeartbeatEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "GMS available and enabled - doing EE initialization");
            }
            orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.folb.ServerGroupManager", "dummy");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Did EE property initialization");
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Doing PE initialization");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Did PE property initialization");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initORB(Properties props) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB->: ");
            }
            GlassFishORBManager.setORBSystemProperties();
            Properties orbInitProperties = new Properties();
            orbInitProperties.putAll((Map<?, ?>)props);
            orbInitProperties.put("com.sun.corba.ee.ORBAppServerMode", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators.org.glassfish.enterprise.iiop.impl.PEORBConfigurator", "dummy");
            GlassFishORBManager.setFOLBProperties(orbInitProperties);
            orbInitProperties.put("org.omg.CORBA.ORBServerId", DEFAULT_SERVER_ID);
            orbInitProperties.put(OMG_ORB_CLASS_PROPERTY, ORB_CLASS);
            orbInitProperties.put("org.omg.PortableInterceptor.ORBInitializerClass.com.sun.enterprise.iiop.GlassFishORBInitializer", "");
            orbInitProperties.put("com.sun.corba.ee.ORBAllowLocalOptimization", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBGetServiceContextReturnsNull", "true");
            orbInitProperties.put(SUN_ORB_ID_PROPERTY, S1AS_ORB_ID);
            orbInitProperties.put("com.sun.corba.ee.ORBShowInfoMessages", "true");
            String initialPort = GlassFishORBManager.checkORBInitialPort(orbInitProperties);
            String orbInitialHost = GlassFishORBManager.checkORBInitialHost(orbInitProperties);
            String[] orbInitRefArgs = System.getProperty(IIOP_ENDPOINTS_PROPERTY) != null && !System.getProperty(IIOP_ENDPOINTS_PROPERTY).equals("") ? GlassFishORBManager.getORBInitRef(System.getProperty(IIOP_ENDPOINTS_PROPERTY)) : GlassFishORBManager.getORBInitRef(orbInitialHost, initialPort);
            GlassFishORBManager.checkAdditionalORBListeners(orbInitProperties);
            GlassFishORBManager.checkConnectionSettings(orbInitProperties);
            GlassFishORBManager.checkMessageFragmentSize(orbInitProperties);
            GlassFishORBManager.checkServerSSLOutboundSettings(orbInitProperties);
            GlassFishORBManager.checkForOrbPropertyValues(orbInitProperties);
            Collection<GlassFishORBLifeCycleListener> lcListeners = iiopUtils.getGlassFishORBLifeCycleListeners();
            ArrayList<String> argsList = new ArrayList<String>();
            for (String a : orbInitRefArgs) {
                argsList.add(a);
            }
            for (GlassFishORBLifeCycleListener listener : lcListeners) {
                listener.initializeORBInitProperties(argsList, orbInitProperties);
            }
            String[] args = argsList.toArray(new String[argsList.size()]);
            if (!iiopUtils.isAppClientContainer()) {
                PEORBConfigurator.setThreadPoolManager();
            }
            ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(GlassFishORBManager.class.getClassLoader());
                orb = ORB.init((String[])args, (Properties)orbInitProperties);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCL);
            }
            try {
                Object obj = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName in) {
                logger.log(Level.SEVERE, "enterprise.orb_reference_exception", in);
            }
            orbInitialPort = GlassFishORBManager.getORBInitialPort();
            for (GlassFishORBLifeCycleListener listener : lcListeners) {
                listener.orbCreated(orb);
            }
            rfm = (ReferenceFactoryManager)orb.resolve_initial_references("ReferenceFactoryManager");
            ASORBUtilities.initGIS(orb);
            ((com.sun.corba.ee.spi.orb.ORB)orb).getFVDCodeBaseIOR();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "enterprise_util.excep_in_createorb", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB<-: ");
            }
        }
    }

    private static String checkForAddrAny(Properties props, String orbInitialHost) {
        if (orbInitialHost.equals("0.0.0.0") || orbInitialHost.equals("::") || orbInitialHost.equals("::ffff:0.0.0.0")) {
            try {
                String localAddress = InetAddress.getLocalHost().getHostAddress();
                return localAddress;
            }
            catch (UnknownHostException uhe) {
                logger.log(Level.WARNING, "Unknown host exception - Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        props.setProperty(SUN_ORB_SERVER_HOST_PROPERTY, orbInitialHost);
        return orbInitialHost;
    }

    private static String checkORBInitialHost(Properties props) {
        String orbInitialHost = System.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        if (orbInitialHost == null) {
            orbInitialHost = props.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        }
        if (orbInitialHost == null) {
            try {
                orbInitialHost = iiopListenerBeans[0].getAddress();
                orbInitialHost = GlassFishORBManager.checkForAddrAny(props, orbInitialHost);
            }
            catch (NullPointerException npe) {
                logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (orbInitialHost == null) {
            orbInitialHost = DEFAULT_ORB_INIT_HOST;
        }
        props.setProperty(OMG_ORB_INIT_HOST_PROPERTY, orbInitialHost);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting orb initial host to " + orbInitialHost);
        }
        return orbInitialHost;
    }

    private static String checkORBInitialPort(Properties props) {
        String initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (initialPort == null) {
            initialPort = props.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        }
        if (initialPort == null) {
            try {
                initialPort = iiopListenerBeans[0].getPort();
                if (!Boolean.valueOf(iiopListenerBeans[0].getEnabled()).booleanValue()) {
                    props.setProperty(ORB_DISABLED_PORTS_PROPERTY, initialPort);
                }
                if (!Boolean.valueOf(iiopListenerBeans[0].getEnabled()).booleanValue()) {
                    props.setProperty(SUN_ORB_SERVER_PORT_PROPERTY, "-1");
                } else {
                    props.setProperty(SUN_ORB_SERVER_PORT_PROPERTY, initialPort);
                }
            }
            catch (NullPointerException npe) {
                logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (initialPort == null) {
            initialPort = DEFAULT_ORB_INIT_PORT;
        }
        props.setProperty(OMG_ORB_INIT_PORT_PROPERTY, initialPort);
        if (!iiopUtils.isAppClientContainer()) {
            props.setProperty("com.sun.corba.ee.POA.ORBPersistentServerPort", initialPort);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting orb initial port to " + initialPort);
        }
        orbInitialPort = new Integer(initialPort);
        return initialPort;
    }

    private static void checkAdditionalORBListeners(Properties props) {
        if (iiopListenerBeans != null) {
            StringBuffer listenSockets = new StringBuffer("");
            for (int i = 0; i < iiopListenerBeans.length; ++i) {
                if (i == 0 && iiopListenerBeans[0].getSsl() == null || !Boolean.valueOf(iiopListenerBeans[i].getEnabled()).booleanValue()) continue;
                if (!Boolean.valueOf(iiopListenerBeans[i].getSecurityEnabled()).booleanValue() || iiopListenerBeans[i].getSsl() == null) {
                    GlassFishORBManager.checkForAddrAny(props, iiopListenerBeans[i].getAddress());
                    listenSockets.append((listenSockets.length() > 0 ? "," : "") + IIOP_CLEAR_TEXT_CONNECTION + ":" + iiopListenerBeans[i].getPort());
                    continue;
                }
                Ssl sslBean = null;
                sslBean = iiopListenerBeans[i].getSsl();
                assert (sslBean != null);
                boolean clientAuth = Boolean.valueOf(sslBean.getClientAuthEnabled());
                String type = clientAuth ? SSL_MUTUALAUTH : SSL;
                listenSockets.append((listenSockets.length() > 0 ? "," : "") + type + ":" + iiopListenerBeans[i].getPort());
            }
            props.setProperty(ORB_LISTEN_SOCKET_PROPERTY, listenSockets.toString());
        }
    }

    private static void checkConnectionSettings(Properties props) {
        if (orbBean != null) {
            String maxConnections;
            try {
                maxConnections = orbBean.getMaxConnections();
                Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException nfe) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                }
                maxConnections = "1024";
            }
            props.setProperty(SUN_MAX_CONNECTIONS_PROPERTY, maxConnections);
        }
    }

    private static void checkMessageFragmentSize(Properties props) {
        if (orbBean != null) {
            String bufferSize;
            String fragmentSize;
            try {
                int fsize = Integer.parseInt(orbBean.getMessageFragmentSize().trim()) / 8 * 8;
                if (fsize < 32) {
                    fragmentSize = "32";
                    logger.log(Level.INFO, "Setting ORB Message Fragment size to " + fragmentSize);
                } else {
                    fragmentSize = String.valueOf(fsize);
                }
                bufferSize = fragmentSize;
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "enterprise_util.excep_in_reading_fragment_size", nfe);
                logger.log(Level.INFO, "Setting ORB Message Fragment size to Default 1024");
                fragmentSize = "1024";
                bufferSize = "1024";
            }
            props.setProperty(SUN_GIOP_FRAGMENT_SIZE_PROPERTY, fragmentSize);
            props.setProperty(SUN_GIOP_BUFFER_SIZE_PROPERTY, bufferSize);
        }
    }

    private static void checkServerSSLOutboundSettings(Properties props) {
        SslClientConfig sslClientConfigBean;
        if (iiopServiceBean != null && (sslClientConfigBean = iiopServiceBean.getSslClientConfig()) != null) {
            Ssl ssl = sslClientConfigBean.getSsl();
            assert (ssl != null);
        }
    }

    private static void checkForOrbPropertyValues(Properties props) {
        List orbBeanProps;
        if (orbBean != null && (orbBeanProps = orbBean.getProperty()) != null) {
            for (int i = 0; i < orbBeanProps.size(); ++i) {
                props.setProperty(((Property)orbBeanProps.get(i)).getName(), ((Property)orbBeanProps.get(i)).getValue());
            }
        }
    }

    private static String[] getORBInitRef(String orbInitialHost, String initialPort) {
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:iiop:1.2@" + orbInitialHost + ":" + initialPort + "/NameService"};
        return newArgs;
    }

    private static String[] getORBInitRef(String endpoints) {
        java.lang.Object[] list = endpoints.split(",");
        String corbalocURL = GlassFishORBManager.getCorbalocURL(list);
        logger.fine("GlassFishORBManager.getORBInitRef = " + corbalocURL);
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:" + corbalocURL + "/NameService"};
        return newArgs;
    }

    public static String getCorbalocURL(java.lang.Object[] list) {
        String corbalocURL = "";
        for (int i = 0; i < list.length; ++i) {
            logger.info("list[i] ==> " + list[i]);
            corbalocURL = corbalocURL.equals("") ? IIOP_URL + ((String)list[i]).trim() : corbalocURL + "," + IIOP_URL + ((String)list[i]).trim();
        }
        logger.info("corbaloc url ==> " + corbalocURL);
        return corbalocURL;
    }
}

