/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.enterprise.iiop.impl.IIOPUtils;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class GlassFishORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final Logger _logger = LogDomains.getLogger(GlassFishORBInitializer.class, (String)"javax.enterprise.resource.corba");

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "J2EE Initializer post_init");
            _logger.log(Level.FINE, "Creating Codec for CDR encoding");
        }
        CodecFactory cf = info.codec_factory();
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(0, major_version, minor_version);
        try {
            codec = cf.create_codec(encoding);
            IIOPUtils iiopUtils = IIOPUtils.getInstance();
            Collection<IIOPInterceptorFactory> interceptorFactories = iiopUtils.getAllIIOPInterceptrFactories();
            for (IIOPInterceptorFactory factory : interceptorFactories) {
                ClientRequestInterceptor clientReq = factory.createClientRequestInterceptor(info, codec);
                ServerRequestInterceptor serverReq = factory.createServerRequestInterceptor(info, codec);
                if (clientReq != null) {
                    info.add_client_request_interceptor(clientReq);
                }
                if (serverReq == null) continue;
                info.add_server_request_interceptor(serverReq);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }
}

