/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolFactory;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.impl.IIOPUtils;

public class S1ASThreadPoolManager
implements ThreadPoolManager {
    static Logger _logger = LogDomains.getLogger(S1ASThreadPoolManager.class, (String)"javax.enterprise.system.util");
    private static final int DEFAULT_NUMBER_OF_QUEUES = 0;
    private static final int DEFAULT_MIN_THREAD_COUNT = 10;
    private static final int DEFAULT_MAX_THREAD_COUNT = 200;
    private static HashMap idToIndexTable = new HashMap();
    private static HashMap indexToIdTable = new HashMap();
    private static ArrayList threadpoolList = new ArrayList();
    private static String defaultID;
    private static ThreadPoolManager s1asThreadPoolMgr;

    public static ThreadPoolManager getThreadPoolManager() {
        return s1asThreadPoolMgr;
    }

    S1ASThreadPoolManager() {
        IIOPUtils iiopUtils = IIOPUtils.getInstance();
        try {
            com.sun.enterprise.config.serverbeans.ThreadPool[] allThreadPools = iiopUtils.getAllThreadPools();
            for (int i = 0; i < allThreadPools.length; ++i) {
                this.createThreadPools(allThreadPools[i], i);
            }
            defaultID = (String)indexToIdTable.get(new Integer(0));
        }
        catch (NullPointerException npe) {
            _logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
    }

    private void createThreadPools(com.sun.enterprise.config.serverbeans.ThreadPool threadpoolBean, int index) {
        int idleTimeoutInSeconds;
        int maxThreads;
        int minThreads;
        String threadpoolId;
        IIOPUtils iiopUtils;
        block22: {
            int numberOfQueues;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            iiopUtils = IIOPUtils.getInstance();
                            threadpoolId = null;
                            minThreads = 10;
                            maxThreads = 200;
                            idleTimeoutInSeconds = 120000;
                            numberOfQueues = 0;
                            try {
                                threadpoolId = threadpoolBean.getThreadPoolId();
                            }
                            catch (NullPointerException npe) {
                                if (!_logger.isLoggable(Level.WARNING)) break block18;
                                _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                            }
                        }
                        try {
                            String minThreadsValue = threadpoolBean.getMinThreadPoolSize();
                            minThreads = Integer.parseInt(minThreadsValue);
                        }
                        catch (NullPointerException npe) {
                            if (_logger.isLoggable(Level.WARNING)) {
                                _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                                _logger.log(Level.WARNING, "Using default value for steady-threadpool-size = " + minThreads);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!_logger.isLoggable(Level.WARNING)) break block19;
                            _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                            _logger.log(Level.WARNING, "Using default value for min-threadpool-size = " + minThreads);
                        }
                    }
                    try {
                        String maxThreadsValue = threadpoolBean.getMaxThreadPoolSize();
                        maxThreads = Integer.parseInt(maxThreadsValue);
                    }
                    catch (NullPointerException npe) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                            _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!_logger.isLoggable(Level.WARNING)) break block20;
                        _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                        _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                    }
                }
                try {
                    String timeoutValue = threadpoolBean.getIdleThreadTimeoutInSeconds();
                    idleTimeoutInSeconds = Integer.parseInt(timeoutValue);
                }
                catch (NullPointerException npe) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                        _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!_logger.isLoggable(Level.WARNING)) break block21;
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                    _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
                }
            }
            try {
                String numberOfQueuesValue = threadpoolBean.getNumWorkQueues();
                numberOfQueues = Integer.parseInt(numberOfQueuesValue);
            }
            catch (NullPointerException npe) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                    _logger.log(Level.WARNING, "Using default value for num-work-queues = " + numberOfQueues);
                }
            }
            catch (NumberFormatException nfe) {
                if (!_logger.isLoggable(Level.WARNING)) break block22;
                _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                _logger.log(Level.WARNING, "Using default value for num-work-queues = " + numberOfQueues);
            }
        }
        ThreadPoolFactory threadPoolFactory = new ThreadPoolFactory();
        ThreadPool threadpool = threadPoolFactory.create(minThreads, maxThreads, (long)(idleTimeoutInSeconds * 1000), threadpoolId, iiopUtils.getCommonClassLoader());
        threadpoolList.add(threadpool);
        idToIndexTable.put(threadpoolId, new Integer(index));
        indexToIdTable.put(new Integer(index), threadpoolId);
    }

    public ThreadPool getThreadPool(String id) throws NoSuchThreadPoolException {
        Integer i = (Integer)idToIndexTable.get(id);
        if (i == null) {
            throw new NoSuchThreadPoolException();
        }
        try {
            ThreadPool threadpool = (ThreadPool)threadpoolList.get(i);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        try {
            ThreadPool threadpool = (ThreadPool)threadpoolList.get(numericIdForThreadpool);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public int getThreadPoolNumericId(String id) {
        Integer i = (Integer)idToIndexTable.get(id);
        return i == null ? 0 : i;
    }

    public String getThreadPoolStringId(int numericIdForThreadpool) {
        String id = (String)indexToIdTable.get(new Integer(numericIdForThreadpool));
        return id == null ? defaultID : id;
    }

    public ThreadPool getDefaultThreadPool() {
        try {
            return this.getThreadPool(0);
        }
        catch (NoSuchThreadPoolException nstpe) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "No default ThreadPool defined ", nstpe);
            }
            return null;
        }
    }

    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }

    public void close() {
    }

    static {
        s1asThreadPoolMgr = new S1ASThreadPoolManager();
    }
}

