/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.copyobject.CopierManager;
import com.sun.corba.ee.spi.copyobject.CopyobjectDefaults;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.orbutil.copyobject.ObjectCopierFactory;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.presentation.rmi.InvocationInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.TSIdentification;

public class PEORBConfigurator
implements ORBConfigurator {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static final String OPT_COPIER_CLASS = "com.sun.corba.ee.spi.copyobject.OptimizedCopyobjectDefaults";
    private static TSIdentification tsIdent;
    private static ORB theORB;
    private static ThreadPoolManager threadpoolMgr;
    private static boolean txServiceInitialized;

    public void configure(DataCollector dc, ORB orb) {
        if (threadpoolMgr != null) {
            orb.setThreadPoolManager(threadpoolMgr);
        }
        PEORBConfigurator.configureCopiers(orb);
        PEORBConfigurator.configureCallflowInvocationInterceptor(orb);
    }

    private static void configureCopiers(ORB orb) {
        CopierManager cpm = orb.getCopierManager();
        ObjectCopierFactory stream = CopyobjectDefaults.makeORBStreamObjectCopierFactory((ORB)orb);
        cpm.registerObjectCopierFactory(stream, 0);
        cpm.setDefaultId(0);
        try {
            Class<?> cls = Class.forName(OPT_COPIER_CLASS);
            PEORBConfigurator.configureOptCopier(orb, cls, stream);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void configureOptCopier(ORB orb, Class cls, ObjectCopierFactory stream) {
        CopierManager cpm = orb.getCopierManager();
        ObjectCopierFactory reference = CopyobjectDefaults.getReferenceObjectCopierFactory();
        try {
            Method m = cls.getMethod("makeReflectObjectCopierFactory", ORB.class);
            ObjectCopierFactory reflect = (ObjectCopierFactory)m.invoke((Object)cls, orb);
            ObjectCopierFactory fallback = CopyobjectDefaults.makeFallbackObjectCopierFactory((ObjectCopierFactory)reflect, (ObjectCopierFactory)stream);
            cpm.registerObjectCopierFactory(fallback, 0);
            cpm.registerObjectCopierFactory(reference, 1);
            cpm.setDefaultId(0);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINE, "Caught NoSuchMethodException - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Caught IllegalAccessException - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, "Caught IllegalArgumentException - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
        catch (InvocationTargetException e) {
            logger.log(Level.FINE, "Caught InvocationTargetException - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
        catch (NullPointerException e) {
            logger.log(Level.FINE, "Caught NullPointerException - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
        catch (ExceptionInInitializerError e) {
            logger.log(Level.FINE, "Caught ExceptionInInitializerError - " + e.getMessage());
            logger.log(Level.FINE, "Proceeding with pass-by-value copier set to stream copier");
        }
    }

    public static void setThreadPoolManager() {
    }

    private static void configureCallflowInvocationInterceptor(ORB orb) {
        orb.setInvocationInterceptor(new InvocationInterceptor(){

            public void preInvoke() {
            }

            public void postInvoke() {
            }
        });
    }

    static {
        threadpoolMgr = null;
        txServiceInitialized = false;
        tsIdent = null;
    }
}

