/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.GlassFishORBLifeCycleListener;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.enterprise.iiop.impl.GlassFishORBManager;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class IIOPUtils
implements PostConstruct {
    private static IIOPUtils _me;
    @Inject
    private Habitat habitat;
    @Inject
    private ClassLoaderHierarchy clHierarchy;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;
    private Collection<ThreadPool> threadPools;
    private IiopService iiopService;
    private Collection<ServerRef> serverRefs;
    private Configs configs;
    private ORB defaultORB;
    private GlassFishORBManager gfORBMgr;

    public void postConstruct() {
        this.processType = this.processEnv.getProcessType();
        if (this.processEnv.getProcessType() == ProcessEnvironment.ProcessType.Server) {
            this.iiopService = (IiopService)this.habitat.getComponent(IiopService.class);
            Collection threadPool = this.habitat.getAllByType(ThreadPool.class);
            Collection listeners = this.habitat.getAllByType(NetworkListener.class);
            TreeSet<String> names = new TreeSet<String>();
            this.threadPools = new ArrayList<ThreadPool>();
            for (NetworkListener listener : listeners) {
                names.add(listener.getThreadPool());
            }
            for (ThreadPool pool : threadPool) {
                if (names.contains(pool.getName())) continue;
                this.threadPools.add(pool);
            }
            this.serverRefs = this.habitat.getAllByContract(ServerRef.class);
            this.configs = (Configs)this.habitat.getComponent(Configs.class);
        }
    }

    public static IIOPUtils getInstance() {
        return _me;
    }

    public static void setInstance(IIOPUtils utils) {
        _me = utils;
    }

    void setGlassFishORBManager(GlassFishORBManager orbMgr) {
        this.gfORBMgr = orbMgr;
    }

    GlassFishORBManager getGlassFishORBManager() {
        return this.gfORBMgr;
    }

    public ClassLoader getCommonClassLoader() {
        return this.clHierarchy.getCommonClassLoader();
    }

    private void assertServer() {
        if (this.processType != ProcessEnvironment.ProcessType.Server) {
            throw new IllegalStateException("Only available in Server mode");
        }
    }

    public IiopService getIiopService() {
        this.assertServer();
        return this.iiopService;
    }

    public Collection<ThreadPool> getAllThreadPools() {
        this.assertServer();
        return this.threadPools;
    }

    public Collection<ServerRef> getServerRefs() {
        this.assertServer();
        return this.serverRefs;
    }

    public List<IiopListener> getIiopListeners() {
        this.assertServer();
        return this.iiopService.getIiopListener();
    }

    public Collection<IIOPInterceptorFactory> getAllIIOPInterceptrFactories() {
        return this.habitat.getAllByContract(IIOPInterceptorFactory.class);
    }

    public Collection<GlassFishORBLifeCycleListener> getGlassFishORBLifeCycleListeners() {
        return this.habitat.getAllByContract(GlassFishORBLifeCycleListener.class);
    }

    public void setORB(ORB orb) {
        this.defaultORB = orb;
    }

    public ORB getORB() {
        return this.defaultORB;
    }
}

