/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.osgi.ORBFactory;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.Utility;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.GlassFishORBLifeCycleListener;
import org.glassfish.enterprise.iiop.impl.CSIv2SSLTaggedComponentHandlerImpl;
import org.glassfish.enterprise.iiop.impl.PEORBConfigurator;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class GlassFishORBManager {
    static Logger logger = LogDomains.getLogger(GlassFishORBManager.class, (String)"javax.enterprise.system.util");
    private static final boolean debug = true;
    private static final String ORB_CLASS = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_CLASS = "com.sun.corba.se.impl.orb.ORBImpl";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String PEORB_CONFIG_CLASS = "org.glassfish.enterprise.iiop.impl.PEORBConfigurator";
    private static final String IIOP_SSL_SOCKET_FACTORY_CLASS = "org.glassfish.enterprise.iiop.impl.IIOPSSLSocketFactory";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private static final String PI_ORB_INITIALIZER_CLASS_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String SUN_USER_CONFIGURATOR_PREFIX = "com.sun.corba.ee.ORBUserConfigurators.";
    public static final String SUN_ORB_ID_PROPERTY = "org.omg.CORBA.ORBId";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.corba.ee.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.corba.ee.ORBServerPort";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBSocketFactoryClass";
    public static final String SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBIORToSocketInfoClass";
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.corba.ee.connection.ORBHighWaterMark";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.corba.ee.transport.ORBListenSocket";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static final String SUN_LISTEN_ADDR_ANY_ADDRESS = "com.sun.CORBA.orb.AddrAnyAddress";
    private static final String ORB_IOR_ADDR_ANY_INITIALIZER = "com.sun.enterprise.iiop.IORAddrAnyInitializer";
    private static final String DEFAULT_SERVER_ID = "100";
    private static final String ACC_DEFAULT_SERVER_ID = "101";
    private static final String USER_DEFINED_ORB_SERVER_ID_PROPERTY = "org.glassfish.orb.iiop.orbserverid";
    private static final String DEFAULT_MAX_CONNECTIONS = "1024";
    private static final String GLASSFISH_INITIALIZER = "org.glassfish.enterprise.iiop.impl.GlassFishORBInitializer";
    private static final String SUN_GIOP_DEFAULT_FRAGMENT_SIZE = "1024";
    private static final String SUN_GIOP_DEFAULT_BUFFER_SIZE = "1024";
    private static final String IIOP_CLEAR_TEXT_CONNECTION = "IIOP_CLEAR_TEXT";
    public static final String DEFAULT_ORB_INIT_HOST = "localhost";
    public static final String DEFAULT_ORB_INIT_PORT = "3700";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String ORB_SSL_CERTDB_PATH = "com.sun.CSIV2.ssl.CertDB";
    private static final String ORB_SSL_CERTDB_PASSWORD = "com.sun.CSIV2.ssl.CertDBPassword";
    private static final String ORB_SSL_STANDALONE_CLIENT_REQUIRED = "com.sun.CSIV2.ssl.standalone.client.required";
    public static final String SUN_GIOP_FRAGMENT_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBFragmentSize";
    public static final String SUN_GIOP_BUFFER_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBBufferSize";
    public static final String S1AS_ORB_ID = "S1AS-ORB";
    private Habitat habitat;
    private IIOPUtils iiopUtils;
    private com.sun.corba.ee.spi.orb.ORB orb = null;
    private ReferenceFactoryManager rfm = null;
    private int orbInitialPort = -1;
    private IiopListener[] iiopListenerBeans = null;
    private Orb orbBean = null;
    private IiopService iiopServiceBean = null;
    private Properties csiv2Props = new Properties();
    private ProcessEnvironment.ProcessType processType;
    private static final Properties EMPTY_PROPERTIES = new Properties();
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private static final String IIOP_URL = "iiop:1.2@";

    GlassFishORBManager(Habitat h) {
        this.habitat = h;
        this.iiopUtils = (IIOPUtils)this.habitat.getComponent(IIOPUtils.class);
        ProcessEnvironment processEnv = (ProcessEnvironment)this.habitat.getComponent(ProcessEnvironment.class);
        this.processType = processEnv.getProcessType();
        this.initProperties();
    }

    public boolean isEjbAdapterName(String[] adapterName) {
        boolean result = false;
        if (this.rfm != null) {
            result = this.rfm.isRfmName(adapterName);
        }
        return result;
    }

    boolean isIsACall(String operationName) {
        return operationName.equals("_is_a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized com.sun.corba.ee.spi.orb.ORB getORB(Properties props) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "GlassFishORBManager.getORB->: " + this.orb);
            }
            if (this.orb == null) {
                this.initORB(props);
            }
            this.iiopUtils.setORB((ORB)this.orb);
            com.sun.corba.ee.spi.orb.ORB oRB = this.orb;
            return oRB;
        }
        finally {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "GlassFishORBManager.getORB<-: " + this.orb);
            }
        }
    }

    Properties getCSIv2Props() {
        return new Properties(this.csiv2Props);
    }

    void setCSIv2Prop(String name, String value) {
        this.csiv2Props.setProperty(name, value);
    }

    int getORBInitialPort() {
        return this.orbInitialPort;
    }

    private void initProperties() {
        if (this.processType == ProcessEnvironment.ProcessType.ACC || this.processType == ProcessEnvironment.ProcessType.Other) {
            String sslClientRequired;
            this.checkORBInitialPort(EMPTY_PROPERTIES);
            if (this.processType != ProcessEnvironment.ProcessType.ACC && (sslClientRequired = System.getProperty(ORB_SSL_STANDALONE_CLIENT_REQUIRED)) != null && sslClientRequired.equals("true")) {
                this.csiv2Props.put("com.sun.CSIV2.ssl.client.required", "true");
            }
        } else {
            this.iiopServiceBean = this.iiopUtils.getIiopService();
            this.iiopListenerBeans = this.iiopServiceBean.getIiopListener().toArray(new IiopListener[0]);
            assert (this.iiopListenerBeans != null && this.iiopListenerBeans.length > 0);
            this.checkORBInitialPort(EMPTY_PROPERTIES);
            this.orbBean = this.iiopServiceBean.getOrb();
            assert (this.orbBean != null);
            this.csiv2Props.put("com.sun.CSIV2.client.auth.required", String.valueOf(this.iiopServiceBean.getClientAuthenticationRequired()));
            boolean corbaSSLRequired = true;
            for (int i = 0; i < this.iiopListenerBeans.length; ++i) {
                if (this.iiopListenerBeans[i].getSsl() != null) continue;
                corbaSSLRequired = false;
                break;
            }
            this.csiv2Props.put("com.sun.CSIV2.ssl.server.required", String.valueOf(corbaSSLRequired));
        }
    }

    private void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                if (System.getProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, GlassFishORBManager.ORB_SE_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, GlassFishORBManager.ORB_CLASS);
                    }
                }
                if (System.getProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, GlassFishORBManager.ORB_SE_SINGLETON_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, GlassFishORBManager.ORB_SINGLETON_CLASS);
                    }
                }
                System.setProperty(GlassFishORBManager.ORB_UTIL_CLASS_PROPERTY, GlassFishORBManager.RMI_UTIL_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, GlassFishORBManager.RMI_STUB_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, GlassFishORBManager.RMI_PRO_CLASS);
                return null;
            }
        });
    }

    private void setFOLBProperties(Properties orbInitProperties) {
        orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.oa.rfm.ReferenceManagerConfigurator", "dummy");
        orbInitProperties.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
        orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.folb.ClientGroupManager", "dummy");
        orbInitProperties.setProperty(SUN_USER_CONFIGURATOR_PREFIX + CSIv2SSLTaggedComponentHandlerImpl.class.getName(), "dummy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initORB(Properties props) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB->: ");
            }
            this.setORBSystemProperties();
            Properties orbInitProperties = new Properties();
            orbInitProperties.putAll((Map<?, ?>)props);
            orbInitProperties.put("com.sun.corba.ee.ORBAppServerMode", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators.org.glassfish.enterprise.iiop.impl.PEORBConfigurator", "dummy");
            this.setFOLBProperties(orbInitProperties);
            String orbDefaultServerId = DEFAULT_SERVER_ID;
            if (!this.processType.isServer() && !this.processType.isStandaloneServer()) {
                orbDefaultServerId = ACC_DEFAULT_SERVER_ID;
            }
            orbDefaultServerId = System.getProperty(USER_DEFINED_ORB_SERVER_ID_PROPERTY, orbDefaultServerId);
            orbInitProperties.put("org.omg.CORBA.ORBServerId", orbDefaultServerId);
            orbInitProperties.put(OMG_ORB_CLASS_PROPERTY, ORB_CLASS);
            orbInitProperties.put("org.omg.PortableInterceptor.ORBInitializerClass.org.glassfish.enterprise.iiop.impl.GlassFishORBInitializer", "");
            orbInitProperties.put("com.sun.corba.ee.ORBAllowLocalOptimization", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBGetServiceContextReturnsNull", "true");
            orbInitProperties.put(SUN_ORB_ID_PROPERTY, S1AS_ORB_ID);
            orbInitProperties.put("com.sun.corba.ee.ORBShowInfoMessages", "true");
            String initialPort = this.checkORBInitialPort(orbInitProperties);
            String orbInitialHost = this.checkORBInitialHost(orbInitProperties);
            String[] orbInitRefArgs = System.getProperty(IIOP_ENDPOINTS_PROPERTY) != null && !System.getProperty(IIOP_ENDPOINTS_PROPERTY).equals("") ? this.getORBInitRef(System.getProperty(IIOP_ENDPOINTS_PROPERTY)) : this.getORBInitRef(orbInitialHost, initialPort);
            if (this.processType.isServer()) {
                this.validateIiopListeners();
                orbInitProperties.put("com.sun.corba.ee.transport.ORBNoDefaultAcceptors", "true");
            }
            this.checkConnectionSettings(orbInitProperties);
            this.checkMessageFragmentSize(orbInitProperties);
            this.checkServerSSLOutboundSettings(orbInitProperties);
            this.checkForOrbPropertyValues(orbInitProperties);
            Collection lcListeners = this.iiopUtils.getGlassFishORBLifeCycleListeners();
            ArrayList<String> argsList = new ArrayList<String>();
            for (String a : orbInitRefArgs) {
                argsList.add(a);
            }
            for (GlassFishORBLifeCycleListener listener : lcListeners) {
                listener.initializeORBInitProperties(argsList, orbInitProperties);
            }
            String[] args = argsList.toArray(new String[argsList.size()]);
            if (this.processType.isServer()) {
                PEORBConfigurator.setThreadPoolManager();
            }
            boolean useOSGI = false;
            ClassLoader prevCL = Utility.getClassLoader();
            try {
                Utility.setContextClassLoader((ClassLoader)GlassFishORBManager.class.getClassLoader());
                if (this.processType.isServer()) {
                    Module corbaOrbModule = null;
                    ModulesRegistry modulesRegistry = (ModulesRegistry)this.habitat.getComponent(ModulesRegistry.class);
                    for (Module m : modulesRegistry.getModules()) {
                        if (!m.getName().equals("glassfish-corba-orb")) continue;
                        corbaOrbModule = m;
                        break;
                    }
                    if (corbaOrbModule != null) {
                        useOSGI = true;
                        corbaOrbModule.start();
                    }
                }
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)prevCL);
            }
            this.orb = ORBFactory.create();
            ORBFactory.initialize((com.sun.corba.ee.spi.orb.ORB)this.orb, (String[])args, (Properties)orbInitProperties, (boolean)useOSGI);
            try {
                Object obj = this.orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName in) {
                logger.log(Level.SEVERE, "enterprise.orb_reference_exception", in);
            }
            if (this.processType.isServer()) {
                this.orbInitialPort = this.getORBInitialPort();
                for (GlassFishORBLifeCycleListener listener : lcListeners) {
                    listener.orbCreated((ORB)this.orb);
                }
                this.rfm = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
            }
            this.orb.getFVDCodeBaseIOR();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "enterprise_util.excep_in_createorb", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB<-: ");
            }
        }
    }

    private String checkForAddrAny(Properties props, String orbInitialHost) {
        if (orbInitialHost.equals("0.0.0.0") || orbInitialHost.equals("::") || orbInitialHost.equals("::ffff:0.0.0.0")) {
            try {
                String localAddress = InetAddress.getLocalHost().getHostAddress();
                return localAddress;
            }
            catch (UnknownHostException uhe) {
                logger.log(Level.WARNING, "Unknown host exception - Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        props.setProperty(SUN_ORB_SERVER_HOST_PROPERTY, orbInitialHost);
        return orbInitialHost;
    }

    private String checkORBInitialHost(Properties props) {
        String orbInitialHost = System.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        if (orbInitialHost == null) {
            orbInitialHost = props.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        }
        if (orbInitialHost == null && this.iiopListenerBeans != null) {
            orbInitialHost = this.iiopListenerBeans[0].getAddress();
            orbInitialHost = this.checkForAddrAny(props, orbInitialHost);
        }
        if (orbInitialHost == null) {
            orbInitialHost = DEFAULT_ORB_INIT_HOST;
        }
        props.setProperty(OMG_ORB_INIT_HOST_PROPERTY, orbInitialHost);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting orb initial host to " + orbInitialHost);
        }
        return orbInitialHost;
    }

    private String checkORBInitialPort(Properties props) {
        String initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (initialPort == null) {
            initialPort = props.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        }
        if (initialPort == null && this.iiopListenerBeans != null) {
            initialPort = this.iiopListenerBeans[0].getPort();
            if (!Boolean.valueOf(this.iiopListenerBeans[0].getEnabled()).booleanValue()) {
                props.setProperty(ORB_DISABLED_PORTS_PROPERTY, initialPort);
            }
        }
        if (initialPort == null) {
            initialPort = DEFAULT_ORB_INIT_PORT;
        }
        props.setProperty(OMG_ORB_INIT_PORT_PROPERTY, initialPort);
        if (this.processType.isServer()) {
            props.setProperty("com.sun.corba.ee.POA.ORBPersistentServerPort", initialPort);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting orb initial port to " + initialPort);
        }
        this.orbInitialPort = new Integer(initialPort);
        return initialPort;
    }

    private void validateIiopListeners() {
        if (this.iiopListenerBeans != null) {
            int lazyCount = 0;
            for (IiopListener ilb : this.iiopListenerBeans) {
                boolean securityEnabled = Boolean.valueOf(ilb.getSecurityEnabled());
                boolean isLazy = Boolean.valueOf(ilb.getLazyInit());
                if (isLazy) {
                    ++lazyCount;
                }
                if (lazyCount > 1) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Only one iiop-listener can be configured with lazy-init=true");
                }
                if (securityEnabled || ilb.getSsl() == null) continue;
                if (isLazy) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Lazy-init not supported for SSL iiop-listeners");
                }
                Ssl sslBean = ilb.getSsl();
                assert (sslBean != null);
            }
        }
    }

    private void checkConnectionSettings(Properties props) {
        if (this.orbBean != null) {
            String maxConnections;
            try {
                maxConnections = this.orbBean.getMaxConnections();
                Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException nfe) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                }
                maxConnections = "1024";
            }
            props.setProperty(SUN_MAX_CONNECTIONS_PROPERTY, maxConnections);
        }
    }

    private void checkMessageFragmentSize(Properties props) {
        if (this.orbBean != null) {
            String bufferSize;
            String fragmentSize;
            try {
                int fsize = Integer.parseInt(this.orbBean.getMessageFragmentSize().trim()) / 8 * 8;
                if (fsize < 32) {
                    fragmentSize = "32";
                    logger.log(Level.INFO, "Setting ORB Message Fragment size to " + fragmentSize);
                } else {
                    fragmentSize = String.valueOf(fsize);
                }
                bufferSize = fragmentSize;
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "enterprise_util.excep_in_reading_fragment_size", nfe);
                logger.log(Level.INFO, "Setting ORB Message Fragment size to Default 1024");
                fragmentSize = "1024";
                bufferSize = "1024";
            }
            props.setProperty(SUN_GIOP_FRAGMENT_SIZE_PROPERTY, fragmentSize);
            props.setProperty(SUN_GIOP_BUFFER_SIZE_PROPERTY, bufferSize);
        }
    }

    private void checkServerSSLOutboundSettings(Properties props) {
        SslClientConfig sslClientConfigBean;
        if (this.iiopServiceBean != null && (sslClientConfigBean = this.iiopServiceBean.getSslClientConfig()) != null) {
            Ssl ssl = sslClientConfigBean.getSsl();
            assert (ssl != null);
        }
    }

    private void checkForOrbPropertyValues(Properties props) {
        List orbBeanProps;
        if (this.orbBean != null && (orbBeanProps = this.orbBean.getProperty()) != null) {
            for (int i = 0; i < orbBeanProps.size(); ++i) {
                props.setProperty(((Property)orbBeanProps.get(i)).getName(), ((Property)orbBeanProps.get(i)).getValue());
            }
        }
    }

    private String[] getORBInitRef(String orbInitialHost, String initialPort) {
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:iiop:1.2@" + orbInitialHost + ":" + initialPort + "/NameService"};
        return newArgs;
    }

    private String[] getORBInitRef(String endpoints) {
        java.lang.Object[] list = endpoints.split(",");
        String corbalocURL = this.getCorbalocURL(list);
        logger.fine("GlassFishORBManager.getORBInitRef = " + corbalocURL);
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:" + corbalocURL + "/NameService"};
        return newArgs;
    }

    private String getCorbalocURL(java.lang.Object[] list) {
        String corbalocURL = "";
        for (int i = 0; i < list.length; ++i) {
            logger.info("list[i] ==> " + list[i]);
            corbalocURL = corbalocURL.equals("") ? IIOP_URL + ((String)list[i]).trim() : corbalocURL + "," + IIOP_URL + ((String)list[i]).trim();
        }
        logger.info("corbaloc url ==> " + corbalocURL);
        return corbalocURL;
    }
}

