/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiejb;

import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgiejb.OSGiEJBContainer;
import org.glassfish.osgijavaeebase.Extender;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class EJBExtender
implements Extender,
SynchronousBundleListener {
    private OSGiEJBContainer c;
    private static final Logger logger = Logger.getLogger(EJBExtender.class.getPackage().getName());
    private BundleContext context;
    private AtomicBoolean started = new AtomicBoolean(false);
    private ServiceRegistration urlHandlerService;

    public EJBExtender(BundleContext context) {
        this.context = context;
    }

    public void start() {
        this.started.set(true);
        this.c = new OSGiEJBContainer(this.context);
        this.context.addBundleListener((BundleListener)this);
        for (Bundle b : this.context.getBundles()) {
            if (!this.isEJBBundle(b) || !this.isReady(b)) continue;
            this.deploy(b);
        }
    }

    public void stop() {
        if (this.started.getAndSet(false)) {
            this.context.removeBundleListener((BundleListener)this);
            if (this.c != null) {
                this.c.undeployAll();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.isLazy(bundle) || !this.isEJBBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                if (!this.isEJBBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 4: {
                if (!this.isEJBBundle(bundle) || !this.c.isDeployed(bundle)) break;
                this.undeploy(bundle);
            }
        }
    }

    private boolean isLazy(Bundle bundle) {
        return "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private boolean isReady(Bundle b) {
        int state = b.getState();
        boolean isActive = (state & 0x20) != 0;
        boolean isStarting = (state & 8) != 0;
        boolean isReady = isActive || this.isLazy(b) && isStarting;
        return isReady;
    }

    private boolean isEJBBundle(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Export-EJB") != null && headers.get("Fragment-Host") == null;
    }

    private void deploy(Bundle b) {
        try {
            this.c.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "EJBExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "EJBExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private void undeploy(Bundle b) {
        try {
            this.c.undeploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "EJBExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "EJBExtender", "undeploy", "Exception Stack Trace", e);
        }
    }
}

