/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiejb;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgiejb.OSGiEJBDeploymentRequest;
import org.glassfish.osgiejb.OSGiEJBUndeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiEJBContainer
extends OSGiContainer {
    private EJBTracker ejbTracker;
    private final InitialContext ic;

    public OSGiEJBContainer(BundleContext ctx) {
        super(ctx);
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.ejbTracker = new EJBTracker();
        this.ejbTracker.open(true);
    }

    protected OSGiUndeploymentRequest createOSGiUndeploymentRequest(Deployment deployer, ServerEnvironmentImpl env, ActionReport reporter, OSGiApplicationInfo osgiAppInfo) {
        return new OSGiEJBUndeploymentRequest(deployer, env, reporter, osgiAppInfo);
    }

    protected OSGiDeploymentRequest createOSGiDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        return new OSGiEJBDeploymentRequest(deployer, archiveFactory, env, reporter, b);
    }

    class EJBTracker
    extends ServiceTracker {
        EJBTracker() {
            super(OSGiEJBContainer.this.getBundleContext(), OSGiApplicationInfo.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            OSGiApplicationInfo osgiApplicationInfo = (OSGiApplicationInfo)OSGiApplicationInfo.class.cast(this.context.getService(reference));
            String exportEJB = (String)osgiApplicationInfo.getBundle().getHeaders().get("Export-EJB");
            if (exportEJB != null) {
                ApplicationInfo ai = osgiApplicationInfo.getAppInfo();
                Application app = (Application)ai.getMetaData(Application.class);
                Vector ejbs = app.getEjbDescriptors();
                System.out.println("addingService: Found " + ejbs.size() + " no. of EJBs");
                AbstractList ejbsToBeExported = new ArrayList();
                if ("ALL".equals(exportEJB)) {
                    ejbsToBeExported = ejbs;
                } else {
                    StringTokenizer st = new StringTokenizer(exportEJB, ",");
                    while (st.hasMoreTokens()) {
                        String next = st.nextToken();
                        for (EjbDescriptor ejb : ejbs) {
                            if (!next.equals(ejb.getName())) continue;
                            ejbsToBeExported.add(ejb);
                        }
                    }
                }
                for (EjbDescriptor ejb : ejbsToBeExported) {
                    this.registerEjbAsService(ejb, osgiApplicationInfo.getBundle());
                }
            }
            return osgiApplicationInfo;
        }

        private void registerEjbAsService(EjbDescriptor ejb, Bundle bundle) {
            System.out.println(ejb);
            if ("Session".equals(ejb.getType())) {
                EjbSessionDescriptor sessionBean = (EjbSessionDescriptor)EjbSessionDescriptor.class.cast(ejb);
                if ("Stateful".equals(sessionBean.getSessionType())) {
                    System.out.println("Stateful session bean can't be registered as OSGi service");
                } else {
                    BundleContext ejbBundleContext = bundle.getBundleContext();
                    for (String lbi : sessionBean.getLocalBusinessClassNames()) {
                        String jndiName = sessionBean.getPortableJndiName(lbi);
                        Object service = null;
                        try {
                            service = OSGiEJBContainer.this.ic.lookup(jndiName);
                        }
                        catch (NamingException e) {
                            e.printStackTrace();
                        }
                        Properties props = new Properties();
                        props.put("jndi-name", jndiName);
                        ejbBundleContext.registerService(lbi, service, (Dictionary)props);
                    }
                }
            } else {
                System.out.println("Only stateless bean or singleton beans can be registered as OSGi service");
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            OSGiApplicationInfo osgiApplicationInfo = (OSGiApplicationInfo)OSGiApplicationInfo.class.cast(this.context.getService(reference));
            ApplicationInfo ai = osgiApplicationInfo.getAppInfo();
            Application app = (Application)ai.getMetaData(Application.class);
            Vector ejbs = app.getEjbDescriptors();
            System.out.println("removedService: Found " + ejbs.size() + " no. of EJBs");
            for (EjbDescriptor ejb : ejbs) {
            }
        }
    }
}

