/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class R4Wire
implements IWire {
    private IModule m_importer = null;
    private IRequirement m_requirement = null;
    private IModule m_exporter = null;
    private ICapability m_capability = null;

    public R4Wire(IModule importer, IRequirement requirement, IModule exporter, ICapability capability) {
        this.m_importer = importer;
        this.m_requirement = requirement;
        this.m_exporter = exporter;
        this.m_capability = capability;
    }

    public IModule getImporter() {
        return this.m_importer;
    }

    public IRequirement getRequirement() {
        return this.m_requirement;
    }

    public IModule getExporter() {
        return this.m_exporter;
    }

    public ICapability getCapability() {
        return this.m_capability;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        String pkgName = Util.getClassPackage(name);
        if (this.m_capability.getNamespace().equals("package") && this.m_capability.getProperties().get("package").equals(pkgName)) {
            if (this.m_exporter == this.m_importer || this.m_capability.getNamespace().equals("package") && ((Capability)this.m_capability).isIncluded(name)) {
                clazz = this.m_exporter.getContentLoader().getClass(name);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        return clazz;
    }

    public URL getResource(String name) throws ResourceNotFoundException {
        URL url = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_capability.getNamespace().equals("package") && this.m_capability.getProperties().get("package").equals(pkgName) && (url = this.m_exporter.getContentLoader().getResource(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return url;
    }

    public Enumeration getResources(String name) throws ResourceNotFoundException {
        Enumeration urls = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_capability.getNamespace().equals("package") && this.m_capability.getProperties().get("package").equals(pkgName) && (urls = this.m_exporter.getContentLoader().getResources(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return urls;
    }

    public String toString() {
        if (this.m_capability.getNamespace().equals("package")) {
            return this.m_importer + " -> " + this.m_capability.getProperties().get("package") + " -> " + this.m_exporter;
        }
        return this.m_importer + " -> " + this.m_capability + " -> " + this.m_exporter;
    }
}

