/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.felix.shell.Command;
import org.osgi.framework.BundleContext;

public class ScrCommand
implements Command {
    private static final String HELP_CMD = "help";
    private static final String LIST_CMD = "list";
    private static final String INFO_CMD = "info";
    private static final String ENABLE_CMD = "enable";
    private static final String DISABLE_CMD = "disable";
    private final BundleContext bundleContext;
    private final ScrService scrService;

    ScrCommand(BundleContext bundleContext, ScrService scrService) {
        this.bundleContext = bundleContext;
        this.scrService = scrService;
    }

    public String getName() {
        return "scr";
    }

    public String getUsage() {
        return "scr help";
    }

    public String getShortDescription() {
        return "Declarative Services Runtime";
    }

    public void execute(String commandLine, PrintStream out, PrintStream err) {
        StringTokenizer st = new StringTokenizer(commandLine);
        st.nextToken();
        String command = HELP_CMD;
        try {
            command = st.nextToken();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (command == null || command.equals(HELP_CMD)) {
            this.help(out, st);
        } else if (command.equals(LIST_CMD)) {
            this.list(st, out, err);
        } else if (command.equals(INFO_CMD)) {
            this.info(st, out, err);
        } else if (command.equals(ENABLE_CMD)) {
            this.change(st, out, err, true);
        } else if (command.equals(DISABLE_CMD)) {
            this.change(st, out, err, false);
        } else {
            err.println("Unknown command: " + command);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void list(StringTokenizer st, PrintStream out, PrintStream err) {
        if (st.hasMoreTokens()) {
            bid = st.nextToken();
            try {
                bundleId = Long.parseLong(bid);
                bundle = this.bundleContext.getBundle(bundleId);
                if (bundle == null) {
                    err.println("Missing bundle with ID " + bundleId);
                    return;
                }
                components = this.scrService.getComponents(bundle);
                if (components != null) ** GOTO lbl19
                out.println("Bundle " + bundleId + " declares no components");
            }
            catch (NumberFormatException nfe) {
                err.println("Cannot parse " + bid + " to a bundleId");
                return;
            }
        } else {
            components = this.scrService.getComponents();
            if (components == null) {
                out.println("No components registered");
            }
        }
lbl19:
        // 5 sources

        out.println("   Id   State          Name");
        for (i = 0; i < components.length; ++i) {
            out.print('[');
            out.print(this.pad(String.valueOf(components[i].getId()), -4));
            out.print("] [");
            out.print(this.pad(this.toStateString(components[i].getState()), 13));
            out.print("] ");
            out.print(components[i].getName());
            out.println();
        }
    }

    private void info(StringTokenizer st, PrintStream out, PrintStream err) {
        Dictionary props;
        Reference[] refs;
        String[] services;
        Component component = this.getComponentFromArg(st, err);
        if (component == null) {
            return;
        }
        out.print("ID: ");
        out.println(component.getId());
        out.print("Name: ");
        out.println(component.getName());
        out.print("Bundle: ");
        out.println(component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
        out.print("State: ");
        out.println(this.toStateString(component.getState()));
        out.print("Default State: ");
        out.println(component.isDefaultEnabled() ? "enabled" : "disabled");
        out.print("Activation: ");
        out.println(component.isImmediate() ? "immediate" : "delayed");
        if (component.getFactory() != null) {
            out.print("Factory: ");
            out.println(component.getFactory());
        }
        if ((services = component.getServices()) != null) {
            out.print("Services: ");
            out.println(services[0]);
            for (int i = 1; i < services.length; ++i) {
                out.print("          ");
                out.println(services[i]);
            }
            out.print("Service Type: ");
            out.println(component.isServiceFactory() ? "service factory" : "service");
        }
        if ((refs = component.getReferences()) != null) {
            for (int i = 0; i < refs.length; ++i) {
                out.print("Reference: ");
                out.println(refs[i].getName());
                out.print("    Satisfied: ");
                out.println(refs[i].isSatisfied() ? "satisfied" : "unsatisfied");
                out.print("    Service Name: ");
                out.println(refs[i].getServiceName());
                if (refs[i].getTarget() != null) {
                    out.print("    Target Filter: ");
                    out.println(refs[i].getTarget());
                }
                out.print("    Multiple: ");
                out.println(refs[i].isMultiple() ? "multiple" : "single");
                out.print("    Optional: ");
                out.println(refs[i].isOptional() ? "optional" : "mandatory");
                out.print("    Policy: ");
                out.println(refs[i].isStatic() ? "static" : "dynamic");
            }
        }
        if ((props = component.getProperties()) != null) {
            out.println("Properties:");
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                Object key = ki.next();
                out.print("    ");
                out.print(key);
                out.print(" = ");
                Object prop = props.get(key);
                if (prop.getClass().isArray()) {
                    prop = Arrays.asList((Object[])prop);
                }
                out.print(prop);
                out.println();
            }
        }
    }

    private void change(StringTokenizer st, PrintStream out, PrintStream err, boolean enable) {
        Component component = this.getComponentFromArg(st, err);
        if (component == null) {
            return;
        }
        if (component.getState() == 256) {
            err.println("Component " + component.getName() + " already destroyed, cannot change state");
        } else if (enable) {
            if (component.getState() == 1) {
                component.enable();
                out.println("Component " + component.getName() + " enabled");
            } else {
                out.println("Component " + component.getName() + " already enabled");
            }
        } else if (component.getState() != 1) {
            component.disable();
            out.println("Componnent " + component.getName() + " disabled");
        } else {
            out.println("Component " + component.getName() + " already disabled");
        }
    }

    private void help(PrintStream out, StringTokenizer st) {
        String command = HELP_CMD;
        if (st.hasMoreTokens()) {
            command = st.nextToken();
        }
        if (command.equals(LIST_CMD)) {
            out.println("");
            out.println("scr list [ <bundleId> ]");
            out.println("");
            out.println("This command lists registered components. If a bundle ID is\nadded, only the components of the selected bundles are listed.");
            out.println("");
        } else if (command.equals(INFO_CMD)) {
            out.println("");
            out.println("scr info <componentId>");
            out.println("");
            out.println("This command dumps information of the component whose\ncomponent ID is given as command argument.");
            out.println("");
        } else if (command.equals(ENABLE_CMD)) {
            out.println("");
            out.println("scr enable <componentId>");
            out.println("");
            out.println("This command enables the component whose component ID\nis given as command argument.");
            out.println("");
        } else if (command.equals(DISABLE_CMD)) {
            out.println("");
            out.println("scr disable <componentId>");
            out.println("");
            out.println("This command disables the component whose component ID\nis given as command argument.");
            out.println("");
        } else {
            out.println("scr help [list]");
            out.println("scr list [ <bundleId> ]");
            out.println("scr info <componentId>");
            out.println("scr enable <componentId>");
            out.println("scr disable <componentId>");
        }
    }

    private String pad(String value, int size) {
        boolean right = size < 0;
        int n = size = right ? -size : size;
        if (value.length() >= size) {
            return value;
        }
        char[] buf = new char[size];
        int padLen = size - value.length();
        int valOff = right ? padLen : 0;
        int padOff = right ? 0 : value.length();
        value.getChars(0, value.length(), buf, valOff);
        Arrays.fill(buf, padOff, padOff + padLen, ' ');
        return new String(buf);
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabled";
            }
            case 4: {
                return "unsatisifed";
            }
            case 8: {
                return "activating";
            }
            case 16: {
                return "active";
            }
            case 32: {
                return "registered";
            }
            case 64: {
                return "factory";
            }
            case 128: {
                return "deactivating";
            }
            case 256: {
                return "destroyed";
            }
        }
        return String.valueOf(state);
    }

    private Component getComponentFromArg(StringTokenizer st, PrintStream err) {
        Component component = null;
        if (st.hasMoreTokens()) {
            String cid = st.nextToken();
            try {
                long componentId = Long.parseLong(cid);
                component = this.scrService.getComponent(componentId);
                if (component == null) {
                    err.println("Missing Component with ID " + componentId);
                }
            }
            catch (NumberFormatException nfe) {
                err.println("Cannot parse " + cid + " to a componentId");
            }
        } else {
            err.println("Component ID required");
        }
        return component;
    }
}

