/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.AbstractComponentManager;
import org.apache.felix.scr.impl.ReferenceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class DependencyManager
implements ServiceListener,
Reference {
    private static final int STATE_MASK = 124;
    private static final Class SERVICE_REFERENCE_CLASS = class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = DependencyManager.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference;
    private static final Object BOUND_SERVICE_SENTINEL = new Object();
    private AbstractComponentManager m_componentManager;
    private ReferenceMetadata m_dependencyMetadata;
    private Map m_bound;
    private int m_size;
    private transient Object m_componentInstance;
    private Method m_bind;
    private boolean m_bindUsesReference;
    private Method m_unbind;
    private boolean m_unbindUsesReference;
    private String m_target;
    private Filter m_targetFilter;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;

    DependencyManager(AbstractComponentManager componentManager, ReferenceMetadata dependency) throws InvalidSyntaxException {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        this.m_bound = Collections.synchronizedMap(new HashMap());
        this.setTargetFilter(this.m_dependencyMetadata.getTarget());
        String filterString = "(objectClass=" + dependency.getInterface() + ")";
        componentManager.getActivator().getBundleContext().addServiceListener((ServiceListener)this, filterString);
        ServiceReference[] refs = this.getFrameworkServiceReferences();
        this.m_size = refs == null ? 0 : refs.length;
        this.m_componentManager.log(4, "Dependency Manager " + this.getName() + " created: filter=" + this.getTarget() + ", interface=" + this.m_dependencyMetadata.getInterface() + ",matching services=" + this.m_size, this.m_componentManager.getComponentMetadata(), null);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        String serviceString = "Service " + this.m_dependencyMetadata.getInterface() + "/" + ref.getProperty("service.id");
        switch (event.getType()) {
            case 1: {
                this.m_componentManager.log(4, "Dependency Manager: Adding " + serviceString, this.m_componentManager.getComponentMetadata(), null);
                if (this.targetFilterMatch(ref)) {
                    ++this.m_size;
                    this.serviceAdded(ref);
                    break;
                }
                this.m_componentManager.log(4, "Dependency Manager: Ignoring added Service for " + this.m_dependencyMetadata.getName() + " : does not match target filter " + this.getTarget(), this.m_componentManager.getComponentMetadata(), null);
                break;
            }
            case 2: {
                this.m_componentManager.log(4, "Dependency Manager: Updating " + serviceString, this.m_componentManager.getComponentMetadata(), null);
                this.serviceRemoved(ref);
                ServiceReference[] refs = this.getFrameworkServiceReferences();
                this.m_size = refs == null ? 0 : refs.length;
                this.serviceAdded(ref);
                break;
            }
            case 4: {
                this.m_componentManager.log(4, "Dependency Manager: Removing " + serviceString, this.m_componentManager.getComponentMetadata(), null);
                if (this.targetFilterMatch(ref)) {
                    --this.m_size;
                } else {
                    this.m_componentManager.log(4, "Dependency Manager: Not counting Service for " + this.m_dependencyMetadata.getName() + " : Service " + ref.getProperty("service.id") + " does not match target filter " + this.getTarget(), this.m_componentManager.getComponentMetadata(), null);
                }
                this.serviceRemoved(ref);
            }
        }
    }

    private void serviceAdded(ServiceReference reference) {
        if (this.m_componentManager.getState() == 4) {
            this.m_componentManager.log(3, "Dependency Manager: Service " + this.m_dependencyMetadata.getName() + " registered, trying to activate", this.m_componentManager.getComponentMetadata(), null);
            this.m_componentManager.activate();
        } else if (this.handleServiceEvent()) {
            if (this.m_dependencyMetadata.isStatic()) {
                if (this.m_dependencyMetadata.isMultiple() || !this.isBound()) {
                    this.m_componentManager.log(4, "Dependency Manager: Service " + this.m_dependencyMetadata.getName() + " registered, reactivate component", this.m_componentManager.getComponentMetadata(), null);
                    this.m_componentManager.reactivate();
                }
            } else if (this.m_dependencyMetadata.getBind() != null) {
                if (this.m_dependencyMetadata.isMultiple() || !this.isBound()) {
                    this.invokeBindMethod(reference);
                } else {
                    ServiceReference[] boundRefs = this.getBoundServiceReferences();
                    if (this.isHigher(reference, boundRefs[0])) {
                        this.invokeBindMethod(reference);
                        this.unbind(boundRefs);
                    }
                }
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service addition, wrong state " + this.m_componentManager.stateToString(this.m_componentManager.getState()), this.m_componentManager.getComponentMetadata(), null);
        }
    }

    private void serviceRemoved(ServiceReference reference) {
        if (this.getBoundService(reference) == null) {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring removed Service for " + this.m_dependencyMetadata.getName() + " : Service " + reference.getProperty("service.id") + " not bound", this.m_componentManager.getComponentMetadata(), null);
            return;
        }
        if (this.handleServiceEvent()) {
            if (!this.isSatisfied()) {
                this.m_componentManager.getActivator().log(4, "Dependency Manager: Deactivating component due to mandatory dependency on " + this.m_dependencyMetadata.getName() + "/" + this.m_dependencyMetadata.getInterface() + " not satisfied", this.m_componentManager.getComponentMetadata(), null);
                this.m_componentManager.deactivate();
            } else if (this.m_dependencyMetadata.isStatic()) {
                try {
                    this.m_componentManager.log(4, "Dependency Manager: Static dependency on " + this.m_dependencyMetadata.getName() + "/" + this.m_dependencyMetadata.getInterface() + " is broken", this.m_componentManager.getComponentMetadata(), null);
                    this.m_componentManager.reactivate();
                }
                catch (Exception ex) {
                    this.m_componentManager.log(1, "Exception while recreating dependency ", this.m_componentManager.getComponentMetadata(), ex);
                }
            } else {
                if (!this.m_dependencyMetadata.isMultiple() && !this.bind()) {
                    this.m_componentManager.log(4, "Dependency Manager: Deactivating component due to mandatory dependency on " + this.m_dependencyMetadata.getName() + "/" + this.m_dependencyMetadata.getInterface() + " not satisfied", this.m_componentManager.getComponentMetadata(), null);
                    this.m_componentManager.deactivate();
                    return;
                }
                if (this.m_dependencyMetadata.getUnbind() != null) {
                    this.invokeUnbindMethod(reference);
                }
            }
        } else {
            this.m_componentManager.log(4, "Dependency Manager: Ignoring service removal, wrong state " + this.m_componentManager.stateToString(this.m_componentManager.getState()), this.m_componentManager.getComponentMetadata(), null);
        }
    }

    private boolean handleServiceEvent() {
        return (this.m_componentManager.getState() & 0x7C) != 0;
    }

    public String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    public ServiceReference[] getServiceReferences() {
        return this.getBoundServiceReferences();
    }

    public boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    public boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    public boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    public String getBindMethodName() {
        return this.m_dependencyMetadata.getBind();
    }

    public String getUnbindMethodName() {
        return this.m_dependencyMetadata.getUnbind();
    }

    void dispose() {
        BundleContext context = this.m_componentManager.getActivator().getBundleContext();
        context.removeServiceListener((ServiceListener)this);
        this.m_size = 0;
        ServiceReference[] boundRefs = this.getBoundServiceReferences();
        if (boundRefs != null) {
            for (int i = 0; i < boundRefs.length; ++i) {
                this.ungetService(boundRefs[i]);
            }
        }
        this.m_bind = null;
        this.m_unbind = null;
    }

    int size() {
        return this.m_size;
    }

    ServiceReference[] getFrameworkServiceReferences() {
        try {
            return this.m_componentManager.getActivator().getBundleContext().getServiceReferences(this.m_dependencyMetadata.getInterface(), this.getTarget());
        }
        catch (InvalidSyntaxException ise) {
            this.m_componentManager.log(1, "Unexpected problem with filter '" + this.getTarget() + "'", this.m_componentManager.getComponentMetadata(), ise);
            return null;
        }
    }

    ServiceReference getFrameworkServiceReference() {
        ServiceReference[] refs = this.getFrameworkServiceReferences();
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        int maxRanking = Integer.MIN_VALUE;
        long minId = Long.MAX_VALUE;
        ServiceReference selectedRef = null;
        for (int i = 0; refs != null && i < refs.length; ++i) {
            ServiceReference ref = refs[i];
            int ranking = this.getServiceRanking(ref);
            long id = this.getServiceId(ref);
            if (maxRanking >= ranking && (maxRanking != ranking || id >= minId)) continue;
            maxRanking = ranking;
            minId = id;
            selectedRef = ref;
        }
        return selectedRef;
    }

    Object getService() {
        ServiceReference sr = this.getFrameworkServiceReference();
        return sr != null ? this.getService(sr) : null;
    }

    Object[] getServices() {
        ServiceReference[] sr = this.getFrameworkServiceReferences();
        if (sr == null || sr.length == 0) {
            return null;
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (int i = 0; i < sr.length; ++i) {
            Object service = this.getService(sr[i]);
            if (service == null) continue;
            services.add(service);
        }
        return services.size() > 0 ? services.toArray() : null;
    }

    private boolean isHigher(ServiceReference newReference, ServiceReference oldReference) {
        int orRank;
        int nrRank = this.getServiceRanking(newReference);
        if (nrRank > (orRank = this.getServiceRanking(oldReference))) {
            return true;
        }
        if (nrRank < orRank) {
            return false;
        }
        try {
            return this.getServiceId(newReference) < this.getServiceId(oldReference);
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getServiceRanking(ServiceReference serviceReference) {
        Object nrRankObj = serviceReference.getProperty("service.ranking");
        if (nrRankObj instanceof Integer) {
            return (Integer)nrRankObj;
        }
        return 0;
    }

    private long getServiceId(ServiceReference serviceReference) {
        return (Long)serviceReference.getProperty("service.id");
    }

    private ServiceReference[] getBoundServiceReferences() {
        return this.m_bound.keySet().toArray(new ServiceReference[this.m_bound.size()]);
    }

    private boolean isBound() {
        return !this.m_bound.isEmpty();
    }

    private void bindService(ServiceReference serviceReference) {
        this.m_bound.put(serviceReference, BOUND_SERVICE_SENTINEL);
    }

    private Object getBoundService(ServiceReference serviceReference) {
        return this.m_bound.get(serviceReference);
    }

    Object getService(ServiceReference serviceReference) {
        Object service = this.getBoundService(serviceReference);
        if (service != null && service != BOUND_SERVICE_SENTINEL) {
            return service;
        }
        service = this.m_componentManager.getActivator().getBundleContext().getService(serviceReference);
        if (service != null) {
            this.m_bound.put(serviceReference, service);
        }
        return service;
    }

    void ungetService(ServiceReference serviceReference) {
        Object service = this.m_bound.remove(serviceReference);
        if (service != null && service != BOUND_SERVICE_SENTINEL) {
            this.m_componentManager.getActivator().getBundleContext().ungetService(serviceReference);
        }
    }

    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    public boolean isSatisfied() {
        return this.size() > 0 || this.m_dependencyMetadata.isOptional();
    }

    boolean open(Object instance) {
        this.m_componentInstance = instance;
        return this.bind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            this.unbind(this.getBoundServiceReferences());
        }
        finally {
            this.m_componentInstance = null;
        }
    }

    private boolean bind() {
        if (!this.isSatisfied()) {
            return false;
        }
        if (this.m_componentInstance == null || this.m_dependencyMetadata.getBind() == null) {
            return true;
        }
        boolean success = this.m_dependencyMetadata.isOptional();
        if (this.m_dependencyMetadata.isMultiple()) {
            ServiceReference[] refs = this.getFrameworkServiceReferences();
            if (refs != null) {
                for (int index = 0; index < refs.length; ++index) {
                    if (!this.invokeBindMethod(refs[index])) continue;
                    success = true;
                }
            }
        } else {
            ServiceReference ref = this.getFrameworkServiceReference();
            if (ref != null && this.invokeBindMethod(ref)) {
                success = true;
            }
        }
        return success;
    }

    private void unbind(ServiceReference[] boundRefs) {
        boolean doUnbind;
        boolean bl = doUnbind = this.m_componentInstance != null && this.m_dependencyMetadata.getUnbind() != null;
        if (boundRefs != null) {
            for (int i = 0; i < boundRefs.length; ++i) {
                if (doUnbind) {
                    this.invokeUnbindMethod(boundRefs[i]);
                }
                this.ungetService(boundRefs[i]);
            }
        }
    }

    private Method getBindingMethod(String methodname, Class targetClass, String parameterClassName) throws InvocationTargetException {
        Class<?> parameterClass = null;
        try {
            return AbstractComponentManager.getMethod(targetClass, methodname, new Class[]{SERVICE_REFERENCE_CLASS}, true);
        }
        catch (NoSuchMethodException ex) {
            try {
                ClassLoader loader = targetClass.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                parameterClass = loader.loadClass(parameterClassName);
                return AbstractComponentManager.getMethod(targetClass, methodname, new Class[]{parameterClass}, true);
            }
            catch (NoSuchMethodException ex2) {
                Method[] candidateBindMethods = targetClass.getDeclaredMethods();
                for (int i = 0; i < candidateBindMethods.length; ++i) {
                    Class<?> theParameter;
                    Method method = candidateBindMethods[i];
                    Class<?>[] parameters = method.getParameterTypes();
                    if (parameters.length != 1 || !method.getName().equals(methodname) || !(theParameter = parameters[0]).isAssignableFrom(parameterClass) || !Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers())) continue;
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method;
                }
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
            return (targetClass = targetClass.getSuperclass()) != null ? this.getBindingMethod(methodname, targetClass, parameterClassName) : null;
        }
    }

    private boolean invokeBindMethod(ServiceReference ref) {
        if (this.m_componentInstance != null) {
            try {
                Object parameter;
                this.m_componentManager.log(4, "getting bind: " + this.m_dependencyMetadata.getBind(), this.m_componentManager.getComponentMetadata(), null);
                if (this.m_bind == null) {
                    this.m_bind = this.getBindingMethod(this.m_dependencyMetadata.getBind(), this.m_componentInstance.getClass(), this.m_dependencyMetadata.getInterface());
                    if (this.m_bind == null) {
                        this.m_componentManager.log(1, "bind() method not found", this.m_componentManager.getComponentMetadata(), null);
                        return true;
                    }
                    this.m_bindUsesReference = SERVICE_REFERENCE_CLASS.equals(this.m_bind.getParameterTypes()[0]);
                }
                if (this.m_bindUsesReference) {
                    parameter = ref;
                    this.bindService(ref);
                } else {
                    parameter = this.getService(ref);
                    if (parameter == null) {
                        this.m_componentManager.log(3, "Dependency Manager: Service " + ref + " has already gone, not binding", this.m_componentManager.getComponentMetadata(), null);
                        return false;
                    }
                }
                this.m_bind.invoke(this.m_componentInstance, parameter);
                this.m_componentManager.log(4, "bound: " + this.getName() + "/" + ref.getProperty("service.id"), this.m_componentManager.getComponentMetadata(), null);
                return true;
            }
            catch (IllegalAccessException ex) {
                this.m_componentManager.log(1, "bind() method cannot be called", this.m_componentManager.getComponentMetadata(), ex);
                return true;
            }
            catch (InvocationTargetException ex) {
                this.m_componentManager.log(1, "DependencyManager : exception while invoking " + this.m_dependencyMetadata.getBind() + "()", this.m_componentManager.getComponentMetadata(), ex);
                return true;
            }
        }
        if (!this.m_componentManager.getComponentMetadata().isImmediate()) {
            this.m_componentManager.log(4, "DependencyManager : Delayed component not yet created, assuming bind method call succeeded", this.m_componentManager.getComponentMetadata(), null);
            return true;
        }
        if (this.m_componentManager.getState() == 8) {
            this.m_componentManager.log(4, "DependencyManager : Not yet open for activating component", this.m_componentManager.getComponentMetadata(), null);
            return true;
        }
        this.m_componentManager.log(1, "DependencyManager : Immediate component not yet created, bind method cannot be called", this.m_componentManager.getComponentMetadata(), null);
        return false;
    }

    private void invokeUnbindMethod(ServiceReference ref) {
        if (this.m_componentInstance != null) {
            try {
                this.m_componentManager.log(4, "getting unbind: " + this.m_dependencyMetadata.getUnbind(), this.m_componentManager.getComponentMetadata(), null);
                if (this.m_unbind == null) {
                    this.m_unbind = this.getBindingMethod(this.m_dependencyMetadata.getUnbind(), this.m_componentInstance.getClass(), this.m_dependencyMetadata.getInterface());
                    if (this.m_unbind == null) {
                        this.m_componentManager.log(1, "unbind() method not found", this.m_componentManager.getComponentMetadata(), null);
                    }
                    this.m_unbindUsesReference = SERVICE_REFERENCE_CLASS.equals(this.m_unbind.getParameterTypes()[0]);
                }
                Object parameter = null;
                if (this.m_unbindUsesReference) {
                    parameter = ref;
                } else {
                    parameter = this.getService(ref);
                    if (parameter == null) {
                        this.m_componentManager.log(3, "Dependency Manager: Service " + ref + " has already gone, not unbinding", this.m_componentManager.getComponentMetadata(), null);
                    }
                }
                this.m_unbind.invoke(this.m_componentInstance, parameter);
                this.m_componentManager.log(4, "unbound: " + this.getName() + "/" + ref.getProperty("service.id"), this.m_componentManager.getComponentMetadata(), null);
            }
            catch (IllegalAccessException ex) {
                this.m_componentManager.log(1, "unbind() method cannot be called", this.m_componentManager.getComponentMetadata(), ex);
            }
            catch (InvocationTargetException ex) {
                this.m_componentManager.log(1, "DependencyManager : exception while invoking " + this.m_dependencyMetadata.getUnbind() + "()", this.m_componentManager.getComponentMetadata(), ex.getCause());
            }
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call unbind method", this.m_componentManager.getComponentMetadata(), null);
        }
    }

    void setTargetFilter(Dictionary properties) {
        this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()));
    }

    private void setTargetFilter(String target) {
        int i;
        ServiceReference[] refs;
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            return;
        }
        this.m_target = target;
        if (target != null) {
            try {
                this.m_targetFilter = this.m_componentManager.getActivator().getBundleContext().createFilter(target);
            }
            catch (InvalidSyntaxException ise) {
                this.m_targetFilter = null;
            }
        } else {
            this.m_targetFilter = null;
        }
        if (this.m_targetFilter != null && (refs = this.getBoundServiceReferences()) != null) {
            for (i = 0; i < refs.length; ++i) {
                if (this.m_targetFilter.match(refs[i])) continue;
                this.serviceRemoved(refs[i]);
            }
        }
        if ((refs = this.getFrameworkServiceReferences()) != null) {
            for (i = 0; i < refs.length; ++i) {
                if (this.getBoundService(refs[i]) != null) continue;
                this.serviceAdded(refs[i]);
            }
            this.m_size = refs.length;
        } else {
            this.m_size = 0;
        }
    }

    public String getTarget() {
        return this.m_target;
    }

    private boolean targetFilterMatch(ServiceReference ref) {
        return this.m_targetFilter == null || this.m_targetFilter.match(ref);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

