/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.cm.PersistenceManager;

class PersistenceManagerProxy
implements PersistenceManager {
    private PersistenceManager delegatee;

    PersistenceManagerProxy(PersistenceManager delegatee) {
        this.setPersistenceManager(delegatee);
    }

    public void delete(String pid) throws IOException {
        this.checkDelegatee();
        this.delegatee.delete(pid);
    }

    public boolean exists(String pid) {
        return this.delegatee != null && this.delegatee.exists(pid);
    }

    public Enumeration getDictionaries() throws IOException {
        this.checkDelegatee();
        return this.delegatee.getDictionaries();
    }

    public Dictionary load(String pid) throws IOException {
        this.checkDelegatee();
        return this.delegatee.load(pid);
    }

    public void store(String pid, Dictionary properties) throws IOException {
        this.checkDelegatee();
        this.delegatee.store(pid, properties);
    }

    void setPersistenceManager(PersistenceManager delegatee) {
        this.delegatee = delegatee;
    }

    void checkDelegatee() throws IOException {
        if (this.delegatee == null) {
            throw new IOException("PersistenceManager not valid");
        }
    }
}

