/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Directive;

public class Clause {
    private final String name;
    private final Directive[] directives;
    private final Attribute[] attributes;

    public Clause(String name, Directive[] directives, Attribute[] attributes) {
        this.name = name;
        this.directives = directives;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public Directive[] getDirectives() {
        return this.directives;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getDirective(String name) {
        for (int i = 0; i < this.directives.length; ++i) {
            if (!name.equals(this.directives[i].getName())) continue;
            return this.directives[i].getValue();
        }
        return null;
    }

    public String getAttribute(String name) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!name.equals(this.attributes[i].getName())) continue;
            return this.attributes[i].getValue();
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        for (i = 0; this.directives != null && i < this.directives.length; ++i) {
            sb.append(";").append(this.directives[i].getName()).append(":=");
            if (this.directives[i].getValue().contains(",")) {
                sb.append("\"").append(this.directives[i].getValue()).append("\"");
                continue;
            }
            sb.append(this.directives[i].getValue());
        }
        for (i = 0; this.attributes != null && i < this.attributes.length; ++i) {
            sb.append(";").append(this.attributes[i].getName()).append("=");
            if (this.attributes[i].getValue().contains(",")) {
                sb.append("\"").append(this.attributes[i].getValue()).append("\"");
                continue;
            }
            sb.append(this.attributes[i].getValue());
        }
        return sb.toString();
    }
}

