/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.LocalResourceImpl;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.SynchronousBundleListener;

public class LocalRepositoryImpl
implements Repository,
SynchronousBundleListener,
AllServiceListener {
    private final BundleContext m_context;
    private final Logger m_logger;
    private long m_snapshotTimeStamp = 0L;
    private Map m_localResourceList = new HashMap();

    public LocalRepositoryImpl(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1) {
            LocalRepositoryImpl localRepositoryImpl = this;
            synchronized (localRepositoryImpl) {
                this.addBundle(event.getBundle(), this.m_logger);
                this.m_snapshotTimeStamp = System.currentTimeMillis();
            }
        }
        if (event.getType() == 16) {
            LocalRepositoryImpl localRepositoryImpl = this;
            synchronized (localRepositoryImpl) {
                this.removeBundle(event.getBundle(), this.m_logger);
                this.m_snapshotTimeStamp = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        Bundle bundle = event.getServiceReference().getBundle();
        if (bundle.getState() == 32 && event.getType() != 2) {
            LocalRepositoryImpl localRepositoryImpl = this;
            synchronized (localRepositoryImpl) {
                this.removeBundle(bundle, this.m_logger);
                this.addBundle(bundle, this.m_logger);
                this.m_snapshotTimeStamp = System.currentTimeMillis();
            }
        }
    }

    private void addBundle(Bundle bundle, Logger logger) {
        if (bundle.getBundleId() == 0L) {
            return;
        }
        try {
            this.m_localResourceList.put(new Long(bundle.getBundleId()), new LocalResourceImpl(bundle));
        }
        catch (InvalidSyntaxException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
        }
    }

    private void removeBundle(Bundle bundle, Logger logger) {
        this.m_localResourceList.remove(new Long(bundle.getBundleId()));
    }

    public void dispose() {
        this.m_context.removeBundleListener((BundleListener)this);
        this.m_context.removeServiceListener((ServiceListener)this);
    }

    public String getURI() {
        return "local";
    }

    public String getName() {
        return "Locally Installed Repository";
    }

    public synchronized long getLastModified() {
        return this.m_snapshotTimeStamp;
    }

    public synchronized Resource[] getResources() {
        return this.m_localResourceList.values().toArray(new Resource[this.m_localResourceList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.m_context.addBundleListener((BundleListener)this);
        this.m_context.addServiceListener((ServiceListener)this);
        Bundle[] bundles = null;
        LocalRepositoryImpl localRepositoryImpl = this;
        synchronized (localRepositoryImpl) {
            bundles = this.m_context.getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                this.addBundle(bundles[i], this.m_logger);
            }
            this.m_snapshotTimeStamp = System.currentTimeMillis();
        }
    }
}

