/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ConfigurationBase;
import org.apache.felix.cm.impl.ConfigurationManager;

class Factory
extends ConfigurationBase {
    public static final String FACTORY_PID = "factory.pid";
    public static final String FACTORY_PID_LIST = "factory.pidList";
    private final Set pids = new HashSet();

    static boolean exists(PersistenceManager persistenceManager, String factoryPid) {
        return persistenceManager.exists(Factory.factoryPidToIdentifier(factoryPid));
    }

    static Factory load(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String factoryPid) throws IOException {
        Dictionary dict = persistenceManager.load(Factory.factoryPidToIdentifier(factoryPid));
        return new Factory(configurationManager, persistenceManager, factoryPid, dict);
    }

    private static String factoryPidToIdentifier(String factoryPid) {
        return factoryPid + ".factory";
    }

    Factory(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String factoryPid) {
        super(configurationManager, persistenceManager, factoryPid, null);
    }

    Factory(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String factoryPid, Dictionary props) {
        super(configurationManager, persistenceManager, factoryPid, (String)props.get("service.bundleLocation"));
        String[] pidList = (String[])props.get(FACTORY_PID_LIST);
        if (pidList != null) {
            for (int i = 0; i < pidList.length; ++i) {
                this.pids.add(pidList[i]);
            }
        }
    }

    String getFactoryPid() {
        return this.getBaseId();
    }

    Set getPIDs() {
        return new HashSet(this.pids);
    }

    boolean addPID(String pid) {
        return this.pids.add(pid);
    }

    boolean removePID(String pid) {
        return this.pids.remove(pid);
    }

    void store() throws IOException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        Factory.replaceProperty(props, "service.bundleLocation", this.getStaticBundleLocation());
        if (!this.pids.isEmpty()) {
            props.put(FACTORY_PID_LIST, this.pids.toArray(new String[this.pids.size()]));
        }
        String id = Factory.factoryPidToIdentifier(this.getFactoryPid());
        if (props.isEmpty()) {
            this.getPersistenceManager().delete(id);
        } else {
            props.put(FACTORY_PID, this.getFactoryPid());
            this.getPersistenceManager().store(id, props);
        }
    }
}

