/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ozark.ext.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mvc.Models;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.servlet.ServletContext;
import org.glassfish.ozark.engine.ViewEngineBase;
import org.glassfish.ozark.engine.ViewEngineConfig;

@ApplicationScoped
public class HandlebarsViewEngine
extends ViewEngineBase {
    @Inject
    private ServletContext servletContext;
    @Inject
    @ViewEngineConfig
    private Handlebars handlebars;

    public boolean supports(String view) {
        return view.endsWith(".hbs") || view.endsWith(".handlebars");
    }

    public void processView(ViewEngineContext context) throws ViewEngineException {
        Models models = context.getModels();
        String viewName = context.getView();
        try (PrintWriter writer = context.getResponse().getWriter();
             InputStream resourceAsStream = this.servletContext.getResourceAsStream(this.resolveView(context));
             InputStreamReader in = new InputStreamReader(resourceAsStream, "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(in);){
            String viewContent = bufferedReader.lines().collect(Collectors.joining());
            Template template = this.handlebars.compileInline(viewContent);
            template.apply((Object)models, (Writer)writer);
        }
        catch (IOException e) {
            throw new ViewEngineException((Throwable)e);
        }
    }
}

