/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ozark.ext.jade;

import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.filter.Filter;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.glassfish.ozark.engine.ViewEngineConfig;
import org.glassfish.ozark.ext.jade.ServletContextTemplateLoader;

public class JadeOzarkConfiguration {
    public static final String MODE = "org.glassfish.ozark.ext.jade.mode";
    public static final String CACHING = "org.glassfish.ozark.ext.jade.caching";
    public static final String PRETTY_PRINT = "org.glassfish.ozark.ext.jade.prettyPrint";
    public static final String FILTER_QUALIFIER = "org.glassfish.ozark.ext.jade.filter";
    public static final String HELPER_QUALIFIER = "org.glassfish.ozark.ext.jade.helper";
    public static final String ENCODING = "org.glassfish.ozark.ext.jade.encoding";
    private Properties configFile;
    @Inject
    private ServletContext servletContext;

    @Produces
    @ViewEngineConfig
    JadeConfiguration produce() {
        this.loadConfig();
        JadeConfiguration jade = new JadeConfiguration();
        jade.setMode(Jade4J.Mode.valueOf((String)this.property(MODE).orElse("XHTML")));
        jade.setCaching(Boolean.valueOf(this.property(CACHING).orElse("true")).booleanValue());
        jade.setPrettyPrint(Boolean.valueOf(this.property(PRETTY_PRINT).orElse("false")).booleanValue());
        for (Map.Entry<String, Object> filter : this.getExtensions(FILTER_QUALIFIER).entrySet()) {
            jade.setFilter(filter.getKey(), (Filter)filter.getValue());
        }
        jade.setSharedVariables(this.getExtensions(HELPER_QUALIFIER));
        String encoding = this.property(ENCODING).orElse("UTF-8");
        jade.setTemplateLoader((TemplateLoader)new ServletContextTemplateLoader(this.servletContext, encoding));
        return jade;
    }

    private void loadConfig() {
        this.configFile = new Properties();
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream("jade.properties");
        if (config != null) {
            try {
                this.configFile.load(config);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Optional<String> property(String key) {
        String property = System.getProperty(key, this.configFile.getProperty(key));
        return Optional.ofNullable(property);
    }

    private Map<String, Object> getExtensions(String qualifier) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.filterProps(this.configFile, qualifier));
        properties.putAll(this.filterProps(System.getProperties(), qualifier));
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        properties.forEach((key, value) -> {
            try {
                Class<?> filter = Class.forName(value);
                extensions.put((String)key, filter.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                String msg = String.format("Jade initialization error: Could not register extension '%s' of type %s", key, value);
                throw new IllegalArgumentException(msg, ex);
            }
        });
        return extensions;
    }

    private Map<String, String> filterProps(Properties props, String qualifier) {
        HashMap<String, String> filters = new HashMap<String, String>();
        props.entrySet().stream().filter(prop -> prop.getKey().toString().startsWith(qualifier)).forEach(prop -> {
            String key = prop.getKey().toString();
            filters.put(key.substring(key.indexOf(qualifier) + qualifier.length() + 1), prop.getValue().toString());
        });
        return filters;
    }

    void dispose(@Disposes @ViewEngineConfig JadeConfiguration jade) {
        jade.clearCache();
    }
}

