/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ozark.ext.jade;

import de.neuland.jade4j.template.TemplateLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.servlet.ServletContext;

class ServletContextTemplateLoader
implements TemplateLoader {
    private final ServletContext servletContext;
    private final String encoding;

    public ServletContextTemplateLoader(ServletContext servletContext, String encoding) {
        Objects.requireNonNull(servletContext, "servletContext must not be null!");
        Objects.requireNonNull(encoding, "encoding must not be null!");
        this.servletContext = servletContext;
        this.encoding = encoding;
    }

    public Reader getReader(String name) throws IOException {
        InputStream inputStream = this.servletContext.getResourceAsStream(name);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("Jade Template '%s' not found.", name));
        }
        return new BufferedReader(new InputStreamReader(inputStream, Charset.forName(this.encoding)));
    }

    public long getLastModified(String name) throws IOException {
        String path = this.servletContext.getRealPath(name);
        if (path == null) {
            return -1L;
        }
        File template = new File(path);
        if (!template.exists()) {
            return -1L;
        }
        return template.lastModified();
    }
}

